% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdaPDE.locator.R
\name{eval.FEM}
\alias{eval.FEM}
\title{Evaluate a FEM object at a set of point locations}
\usage{
eval.FEM(FEM, locations, CPP_CODE = TRUE)
}
\arguments{
\item{FEM}{A \code{FEM} object to be evaluated.}

\item{locations}{A 2-colums matrix with the spatial locations where the FEM object should be evaluated.}

\item{CPP_CODE}{Boolean. If \code{TRUE} the computation relies on the C++ implementation of a Visibility Walk Algorithm (Devillers et al. 2001). This usually ensures a fast computation.}
}
\value{
A matrix of numeric evaluations of the \code{FEM} object. Each row indicates the location where the evaluation has been taken, the column indicates the 
function evaluated.
}
\description{
It evaluates a FEM object the specified set of locations.
}
\references{
Devillers, O. et al. 2001. Walking in a Triangulation, Proceedings of the Seventeenth Annual Symposium on Computational Geometry
}

