% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kernel.asymmetric.R
\name{Kernel.asymmetric}
\alias{Kernel.asymmetric}
\alias{AKer.norm}
\alias{AKer.cos}
\alias{AKer.epa}
\alias{AKer.tri}
\alias{AKer.quar}
\alias{AKer.unif}
\title{Asymmetric Smoothing Kernel}
\usage{
Kernel.asymmetric(u, type.Ker = "AKer.norm")
}
\arguments{
\item{u}{Data.}

\item{type.Ker}{Type of asymmetric metric kernel, by default asymmetric
normal kernel.}
}
\value{
Returns asymmetric kernel.
}
\description{
Represent Asymmetric Smoothing Kernels: normal, cosine, triweight, quartic
and uniform. \tabular{ll}{ \tab AKer.norm=ifelse(u>=0,2*dnorm(u),0)\cr \tab
AKer.cos=ifelse(u>=0,pi/2*(cos(pi*u/2)),0)\cr \tab AKer.epa=ifelse(u>=0 &
u<=1,3/2*(1-u^2),0)\cr \tab AKer.tri=ifelse(u>=0 &
u<=1,35/16*(1-u^2)^3,0)\cr \tab AKer.quar=ifelse(u>=0 &
u<=1,15/8*(1-u^2)^2,0)\cr \tab AKer.unif=ifelse(u>=0 & u<=1,1,0)\cr }
}
\details{
Type of Asymmetric kernel: \tabular{ll}{ \tab Asymmetric Normal Kernel:
\code{AKer.norm}\cr \tab Asymmetric Cosine Kernel: \code{AKer.cos}\cr \tab
Asymmetric Epanechnikov Kernel: \code{AKer.epa}\cr \tab Asymmetric Triweight
Kernel: \code{AKer.tri}\cr \tab Asymmetric Quartic Kernel:
\code{AKer.quar}\cr \tab Asymmetric Uniform Kernel: \code{AKer.unif}\cr }
}
\examples{
y=qnorm(seq(.1,.9,len=100))
a<-Kernel.asymmetric(u=y)
b<-Kernel.asymmetric(type.Ker="AKer.tri",u=y)
c=AKer.cos(y)
}
\references{
Ferraty, F. and Vieu, P. (2006). \emph{Nonparametric functional
data analysis.} Springer Series in Statistics, New York.

Hardle, W. \emph{Applied Nonparametric Regression}. Cambridge University
Press, 1994.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{kernel}
