% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.classif.DD.R
\name{predict.classif.DD}
\alias{predict.classif.DD}
\title{Predicts from a fitted classif.DD object.}
\usage{
\method{predict}{classif.DD}(object, new.fdataobj = NULL,
  type = "class", ...)
}
\arguments{
\item{object}{Object \code{object} estimated by \code{classif.DD}.}

\item{new.fdataobj}{By default, new p functional explanatory dataset or new
mulitvariate data of \code{data.frame} class}

\item{type}{!=''predictive'', for each row of data shows the probability of
each group membership.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
\itemize{
\item {group.pred}{Vector of groups or classes predicted}
\item {prob.group}{For each functional data shows the probability of each
group membership.}
}
}
\description{
Classifier of functional (and multivariate) data by DD--classifier.
}
\details{
Returns the groups or classes predicted using a previously trained model.
}
\examples{
\dontrun{
# DD-classif for multivariate data 
data(iris)
iris<-iris[1:100,]
ii<-sample(1:100,80)
group.train<-factor(iris[ii,5])
x.train<-iris[ii,1:4]
out1=classif.DD(group.train,x.train,depth="MhD",classif="lda")
out2=classif.DD(group.train,x.train,depth="MhD",classif="glm")
summary(out1)
summary(out2)
x.test<-iris[-ii,1:4]
pred1=predict(out1,x.test)
pred2=predict(out2,x.test)
group.test<-iris[-ii,5]
table(pred1,group.test)
table(pred2,group.test)

# DD-classif for Functional data
data(phoneme)
mlearn<-phoneme[["learn"]]
glearn<-phoneme[["classlearn"]]

#	ESTIMATION 
out1=classif.DD(glearn,mlearn,depth="FM",classif="glm")
summary(out1)
#	PREDICTION 
mtest<-phoneme[["test"]]
gtest<-phoneme[["classtest"]]
pred1=predict(out1,mtest)
table(pred1,gtest)
}
}
\references{
Li, J., P.C., Cuesta-Albertos, J.A. and Liu, R.
\emph{DD--Classifier: Nonparametric Classification Procedure Based on
DD-plot}.  Journal of the American Statistical Association (2012), Vol. 107,
737--753.
}
\seealso{
See also \code{\link{classif.DD}} .
}
\author{
Febrero-Bande, M., and Oviedo de la Fuente, M.
}
\keyword{classif}
