% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedParts.R
\name{pedParts}
\alias{pedParts}
\alias{offspringfb}
\alias{spousesfb}
\alias{related.pairs}
\alias{unrelatedfb}
\alias{leavesfb}
\alias{parentsfb}
\alias{grandparentsfbfb}
\alias{siblingsfb}
\alias{cousins}
\alias{nephews_niecesfb}
\alias{ancestorsfb}
\alias{descendantsfb}
\title{Pedigree subsets}
\usage{
offspringfb(x, id, original.id = TRUE)

spousesfb(x, id, original.id = TRUE)

related.pairs(
  x,
  relation = c("parentsfb", "siblingsfb", "grandparentsfbfb", "nephews_niecesfb",
    "cousins", "spousesfb", "unrelatedfb"),
  available = F,
  interfam = c("none", "founders", "all"),
  ...
)

unrelatedfb(x, id, original.id = TRUE)

leavesfb(x)

parentsfb(x, id, original.id = TRUE)

grandparentsfbfb(x, id, degree = 2, original.id = TRUE)

siblingsfb(x, id, half = NA, original.id = TRUE)

cousins(x, id, degree = 1, removal = 0, half = NA, original.id = TRUE)

nephews_niecesfb(x, id, removal = 1, half = NA, original.id = TRUE)

ancestorsfb(x, id)

descendantsfb(x, id, original.id = TRUE)
}
\arguments{
\item{x}{a \code{\link{linkdat}} object. In \code{related.pairs} possibly a
list of \code{linkdat} objects.}

\item{id}{a numerical ID label.}

\item{original.id}{a logical indicating whether 'id' refers to the original
ID label or the internal labeling.}

\item{relation}{one of the words (possibly truncated) \code{parentsfb},
\code{siblingsfb}, \code{grandparentsfbfb}, \code{nephews_niecesfb},
\code{cousins}, \code{spousesfb}, \code{unrelatedfb}.}

\item{available}{a logical, if TRUE only pairs of available individuals are
returned.}

\item{interfam}{one of the words (possibly truncated) \code{none},
\code{founders} or \code{all}, specifying which interfamiliar pairs should
be included as unrelatedfb in the case where \code{x} is a list of several
pedigrees. If \code{none}, only intrafamiliar pairs are considered; if
\code{founders} all interfamiliar pairs of (available) founders are
included; if \code{all}, all interfamiliar (available) pairs are included.}

\item{...}{further parameters}

\item{degree}{a non-negative integer.}

\item{half}{a logical or NA. If TRUE (resp FALSE), only half (resp. full)
siblingsfb/cousins/nephews/nieces are returned. If NA, both categories are
included.}

\item{removal}{a non-negative integer}
}
\value{
For \code{ancestorsfb(x,id)}, a vector containing the ID's of all
ancestorsfb of the individual \code{id}.  For \code{descendantsfb(x,id)}, a
vector containing the ID's of all descendantsfb (i.e. children,
grandchildren, a.s.o.) of individual \code{id}.

The functions \code{cousins}, \code{grandparentsfbfb}, \code{nephews_niecesfb},
\code{offspringfb}, \code{parentsfb}, \code{siblingsfb}, \code{spousesfb},
\code{unrelatedfb}, each returns an integer vector containing the ID's of all
pedigree members having the specified relationship with \code{id}.

For \code{related.pairs} a matrix with two columns. Each row gives of a
pair of pedigree members with the specified relation. If the input is a
list of multiple pedigrees, the matrix entries are characters of the form
'X-Y' where X is the family ID and Y the individual ID of the person.

For \code{leavesfb}, a vector of IDs containing all pedigree members without
children.
}
\description{
Utility functions for 'linkdat' objects, mainly for extracting various
pedigree information.
}
