% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{gamma2norm}
\alias{gamma2norm}
\title{Convert gamma to normal}
\usage{
gamma2norm(x, mu = 0, sd = 1, shape = NULL, rate = 1, scale = 1/rate)
}
\arguments{
\item{x}{the gamma distributed vector}

\item{mu}{the mean of the normal distribution to convert to}

\item{sd}{the SD of the normal distribution to convert to}

\item{shape}{gamma distribution parameter (must be positive)}

\item{rate}{an alternative way to specify the scale}

\item{scale}{gamma distribution parameter (must be positive)}
}
\value{
a vector with a normal distribution
}
\description{
Convert gamma to normal
}
\examples{

x <- rgamma(10000, 2)
y <- gamma2norm(x)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
