% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{unif2norm}
\alias{unif2norm}
\title{Convert normal to uniform}
\usage{
unif2norm(x, mu = 0, sd = 1, min = NULL, max = NULL)
}
\arguments{
\item{x}{the uniformly distributed vector}

\item{mu}{the mean of the normal distribution to return}

\item{sd}{the SD of the normal distribution to return}

\item{min}{the minimum possible value of x (calculated from x if not given)}

\item{max}{the maximum possible value of x (calculated from x if not given)}
}
\value{
a vector with a gaussian distribution
}
\description{
Convert a uniform distribution to a normal (gaussian) distribution with specified mu and sd
}
\examples{

x <- runif(10000)
y <- unif2norm(x)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
