% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.explain}
\alias{autoplot.explain}
\title{Plotting Shapley values}
\usage{
\method{autoplot}{explain}(
  object,
  type = c("importance", "dependence", "contribution"),
  feature = NULL,
  num_features = NULL,
  X = NULL,
  color_by = NULL,
  smooth = FALSE,
  smooth_color = "red",
  smooth_linetype = "solid",
  smooth_size = 1,
  smooth_alpha = 1,
  row_num = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{"explain"}.}

\item{type}{Character string specifying which type of plot to construct. 
Current options are \code{"importance"} (for Shapley-based variable 
importance plots), \code{"dependence"} (for Shapley-based dependence 
plots), and \code{"contribution"} (for visualizing the feature contributions
to an individual prediction).}

\item{feature}{Character string specifying which feature to use when 
\code{type = "dependence"}. If \code{NULL} (default) the first feature will
be used to construct the plot.}

\item{num_features}{Integer specifying the number of variables to plot. 
Default is \code{NULL} which will cause all variables to be displayed.}

\item{X}{A matrix-like R object (e.g., a data frame or matrix) containing 
ONLY the feature columns from the training data.}

\item{color_by}{Character string specifying an optional feature column in 
\code{X} to use for coloring whenever \code{type = "dependence"}.}

\item{smooth}{Logical indicating whether or not to add a smoother to the
scatterplot whenever \code{type = "dependence"}. Default is \code{TRUE}.}

\item{smooth_color}{The color to use for the smoother whenever 
\code{smooth = TRUE}. The default is \code{"black"}; see 
\code{\link[ggplot2]{geom_smooth}} for details.}

\item{smooth_linetype}{The type of line to use for the smoother whenever 
\code{smooth = TRUE}. The default is \code{"solid"}; see 
\code{\link[ggplot2]{geom_smooth}} for details.}

\item{smooth_size}{The size to use for the smoother whenever 
\code{smooth = TRUE}. The default is \code{1}; see 
\code{\link[ggplot2]{geom_smooth}} for details.}

\item{smooth_alpha}{The transparency to use for the smoother whenever 
\code{smooth = TRUE}. The default is \code{1}; see 
\code{\link[ggplot2]{geom_smooth}} for details.}

\item{row_num}{Integer specifying a single row/instance in \code{object} to
plot the explanation when \code{type = "contribution"}. If \code{NULL} (the 
default) the explanation for the first row/instance will be used.}

\item{...}{Additional optional arguments to be passed on to 
\code{\link[ggplot2]{geom_col}} (if \code{type = "importance"}) or 
\code{\link[ggplot2]{geom_point}} (if \code{type = "dependence"}).}
}
\value{
A \code{"ggplot"} object; see 
\code{\link[ggplot2]{ggplot2-package}} for details.
}
\description{
Construct Shapley-based importance plots or Shap-based dependence plots.
}
\examples{
#
# A projection pursuit regression (PPR) example
#

# Load the sample data; see ?datasets::mtcars for details
data(mtcars)

# Fit a projection pursuit regression model
mtcars.ppr <- ppr(mpg ~ ., data = mtcars, nterms = 1)

# Compute approximate Shapley values using 10 Monte Carlo simulations
set.seed(101)  # for reproducibility
shap <- explain(mtcars.ppr, X = subset(mtcars, select = -mpg), nsim = 10, 
                pred_wrapper = predict)
shap

# Shapley-based plots
library(ggplot2)
autoplot(shap)  # Shapley-based importance plot
autoplot(shap, type = "dependence", feature = "wt", X = mtcars)
autoplot(shap, type = "contribution", row_num = 1)  # explain first row of X
}
