% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm.r
\name{.rm}
\alias{.rm}
\title{Delete objects in the active GRASS session}
\usage{
.rm(x, type = NULL, warn = TRUE, verify = TRUE)
}
\arguments{
\item{x}{Character, a \code{GSpatial} object, or missing (default):
\itemize{
\item Character:
\itemize{
\item Any of \code{"rasters"} (all rasters), \code{"vectors"} (all spatial vectors), \code{"rasters3d"} (3D-rasters), and/or \code{"groups"} (groups), and all of these types will be deleted. Partial matching is supported.
\item The \code{sources} of the object to be deleted. Argument \code{type} must be specified.
}
\item \code{GSpatial} object (i.e., a \code{GRaster} or \code{GVector}): Delete this object.
\item Missing: Delete everything in the active \strong{GRASS} session.
}}

\item{type}{The type of spatial objects to delete. This can include \code{"rasters"} (all rasters), \code{"vectors"} (all spatial vectors), \code{"rasters3d"} (3D-rasters), and/or \code{"groups"} (groups). Partial matching is supported. If missing, all objects are candidates for deletion if they match \code{x}.}

\item{warn}{Logical: If \code{TRUE} (default), display warning if no matches or if everything in \strong{GRASS} is to be deleted.}

\item{verify}{Logical: If \code{TRUE} (default), the function will search for the item(s) to be deleted first to verify they exist. If this is \code{FALSE}, then \code{x} MUST be specified and \code{type} must be '\code{raster}' or \code{'vector'} (one value per value in \code{x}). This has no effect if \code{x} is a \code{GSpatial} object. It's main use is to save a bit of time.}
}
\value{
\code{TRUE} (invisibly).
}
\description{
Delete the names of all rasters and/or vectors that have been exported to or created in the active \strong{GRASS} session's location and mapset.
}
\seealso{
\code{\link[=rm]{rm()}}
}
\keyword{internal}
