% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict.fastTS}
\alias{predict.fastTS}
\title{Predict function for fastTS object}
\usage{
\method{predict}{fastTS}(object, n_ahead = 1, X_test, y_test, cumulative = 0, ...)
}
\arguments{
\item{object}{an fastTS object}

\item{n_ahead}{number of times ahead to predict by iteration}

\item{X_test}{a matrix exogenous features}

\item{y_test}{the test series; needed for future predictions (optional; see
details)}

\item{cumulative}{should cumulative (rolling) sums be returned (integer
indicating number of times to sum)}

\item{...}{currently unused}
}
\value{
a vector of predictions
}
\description{
Predict function for fastTS object
}
\details{
The `y_test` argument must be supplied if forecasts are desired or if
`n_ahead` < `nrow(X_test)`. This is because in order to obtain 1-step
forecast for, say, the 10th observation in the test data set, the 9th
observation of `y_test` is required. The length of `y_test` will determine
how many forecasts to produce. In order to get true forecasts for the first
30 observations after the training set, one must (currently) produce the set
of 1-step, 2-step, 3-step, ..., 30-step ahead predictions.
}
\examples{
data("LakeHuron")
fit_LH <- fastTS(LakeHuron)
predict(fit_LH)

}
