% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{PetStress}
\alias{PetStress}
\title{Pets and stress}
\format{
A data frame with 45 observations on the following 2 variables.
\itemize{ \item{group}{ a factor with levels \code{C}ontrol,
\code{F}riend, or \code{P}et} \item{rate}{ average heart rate while
performing a stressful task} }
}
\source{
K. M. Allen, J. Blascovich, J. Tomaka, and R. M. Kelsey, Presence of
human friends and pet dogs as moderators of autonomic responses to stress in
women, \emph{Journal of Personality and Social Psychology} 61 (1991), no. 4,
582--589.
}
\description{
Does having a pet or a friend cause more stress?
}
\details{
Fourty-five women, all self-proclaimed dog-lovers, were randomly divided
into three groups of subjects. Each performed a stressful task either alone,
with a friend present, or with their dog present.  The average heart rate
during the task was used as a measure of stress.
}
\examples{

data(PetStress)
xyplot(rate ~ group, data = PetStress, jitter.x = TRUE, type = c('p', 'a'))
gf_jitter(rate ~ group, data = PetStress, width = 0.1, height = 0) \%>\%
  gf_line(group = 1, stat = "summary", color = "red")

}
\references{
These data also appear in

Brigitte Baldi and David S. Moore, \emph{The Practice of Statistics in the
Life Sciences}, Freeman, 2009.
}
\keyword{datasets}
