% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{intvec_to_fmm}
\alias{intvec_to_fmm}
\title{Convert a numeric integer vector to Matrix Market Format}
\arguments{
\item{input}{A numeric integer vector to be converted.}

\item{filename}{The name of the output file where the Matrix Market formatted
data will be saved.}
}
\value{
A boolean indicating success or failure. Writes a MTX file to disk.
}
\description{
This function takes a numeric intvector and converts it into a
Matrix Market output file.
}
\examples{
intvec <- c(1L, 2L, 3L)
intvec_to_fmm(intvec, tempfile(fileext = ".mtx"))
}
