/*
 * Decompiled with CFR 0.152.
 */
package jfm.lp;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import jfm.lp.LPPeer;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.lp.Objective;
import jfm.model.BadModelException;
import jfm.model.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Matrix {
    private final Stack<MatrixVariable> modifiedVariables = new Stack();
    private final List<MatrixRow> constraints = new ArrayList<MatrixRow>();
    private final List<MatrixVariable> variables = new ArrayList<MatrixVariable>();
    private final Map<Types.ObjectiveType, Objective> objectives;
    private final Set<ModelComponent> components = new LinkedHashSet<ModelComponent>();
    public final PrimitiveMatrix primitiveMatrix;
    private final LPPeer solver;
    private boolean needsBuild = true;
    private boolean alwaysFullRebuild = false;
    private LPX solutionStatus = LPX.LPX_UNDEF;

    public void disableSolverOutput() {
        this.solver.setTermOut(LPX.LPX_TERMOFF);
    }

    public void enableSolverOutput() {
        this.solver.setTermOut(LPX.LPX_TERMON);
    }

    public void flagForRebuild() {
        this.needsBuild = true;
    }

    public void flagForAlwaysRebuild() {
        this.alwaysFullRebuild = true;
    }

    public boolean needsRebuild() {
        return this.needsBuild;
    }

    public LPX getSolutionStatus() {
        return this.solutionStatus;
    }

    public Map<Types.ObjectiveType, Objective> objectives() {
        return Collections.unmodifiableMap(this.objectives);
    }

    public void addObjective(Objective obj) {
        this.objectives.put(obj.type, obj);
        this.needsBuild = true;
    }

    public void addVariable(MatrixVariable v) {
        this.variables.add(v);
        this.flagForRebuild();
    }

    public void addRow(MatrixRow r) {
        this.constraints.add(r);
        this.flagForRebuild();
    }

    public int numCols() {
        return this.variables.size();
    }

    public int numRows() {
        return this.constraints.size();
    }

    public LPPeer.Solver getSolverType() {
        return this.solver.type;
    }

    public Matrix(Set<ModelComponent> cmpIn, Map<Types.ObjectiveType, Objective> objin, LPPeer.Solver solverType) throws BadModelException {
        for (ModelComponent mc : cmpIn) {
            this.addComponent(mc);
        }
        this.objectives = objin;
        this.doCompleteBuild();
        this.primitiveMatrix = new PrimitiveMatrix(this);
        this.solver = LPPeer.create(this, solverType);
        this.modifiedVariables.clear();
    }

    private void doCompleteBuild() throws BadModelException {
        this.variables.clear();
        for (ModelComponent component : this.components) {
            component.initializeStructure();
        }
        for (Objective obj : this.objectives.values()) {
            obj.clearVariables();
        }
        boolean needsDummy = false;
        for (Objective obj : this.objectives.values()) {
            if (!obj.isCurved) continue;
            obj.initializeStructure();
            if (this.objectives.containsKey((Object)Types.ObjectiveType.SOS2DUMMY)) continue;
            needsDummy = true;
        }
        if (needsDummy) {
            this.objectives.put(Types.ObjectiveType.SOS2DUMMY, new Objective(Types.ObjectiveType.SOS2DUMMY));
        }
        for (MatrixVariable var : this.variables) {
            for (Types.ObjectiveType ot : var.objectivesSet()) {
                if (this.objectives.containsKey((Object)ot)) {
                    this.objectives.get((Object)ot).registerVariable(var);
                    continue;
                }
                throw new Error("A Variable with tag " + var.tag() + " was defined for " + (Object)((Object)ot) + " but no concrete object exists for this objective which is one of" + var.objectivesSet());
            }
        }
        this.constraints.clear();
        for (Objective obj : this.objectives.values()) {
            if (!obj.isCurved) continue;
            obj.buildConstraints(this);
        }
        for (ModelComponent component : this.components) {
            component.buildConstraints();
        }
        this.needsBuild = false;
    }

    public void addComponent(ModelComponent newComp) {
        if (this.components.contains(newComp)) {
            throw new Error("The component " + newComp.name() + " is already defined for this matrix");
        }
        newComp.registerMatrix(this);
        this.components.add(newComp);
        this.needsBuild = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LPX updateAndSolve() throws BadModelException {
        if (this.needsBuild || this.alwaysFullRebuild) {
            this.doCompleteBuild();
            if (this.primitiveMatrix == null) throw new Error("Why does this happen? primitiveMatrix is null");
            this.primitiveMatrix.fullReset(this);
        } else {
            this.updateStructure();
            if (this.primitiveMatrix == null) throw new Error("Why does this happen? primitiveMatrix is null");
            if (this.solver.type == LPPeer.Solver.CLP) {
                this.primitiveMatrix.updateCoefficients();
            } else {
                this.primitiveMatrix.fullReset(this);
            }
        }
        this.solutionStatus = this.solver.solve();
        return this.solutionStatus;
    }

    private void updateStructure() {
        for (ModelComponent component : this.components) {
            component.updateStructure();
        }
        while (!this.modifiedVariables.empty()) {
            this.modifiedVariables.pop().commitToMatrix(this.primitiveMatrix);
        }
    }

    private int totalNumElements() {
        int total = 0;
        for (int i = 0; i < this.constraints.size(); ++i) {
            total += this.constraints.get(i).elements().size();
        }
        return total;
    }

    void addModifiedVariableToStack(MatrixVariable var) {
        if (!this.modifiedVariables.contains(var)) {
            this.modifiedVariables.add(var);
        }
    }

    public void printCSV(String filename) {
        PrintWriter writer;
        try {
            writer = new PrintWriter(new FileOutputStream(filename));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new Error("in printCSV");
        }
        writer.print("tag,bound type,low bound ,up bound,");
        for (MatrixVariable cv : this.variables) {
            writer.print(cv.tag() + ",");
        }
        writer.println();
        writer.print(",,,,");
        for (MatrixVariable cv : this.variables) {
            if (cv.objectivesSet().size() > 1) {
                for (Types.ObjectiveType ot : cv.objectivesSet()) {
                    writer.print((Object)((Object)ot) + "(" + cv.getCoefficientForObjective(ot) + ")");
                }
            } else {
                writer.print(cv.getPrimaryObjectiveCoefficient());
            }
            writer.print(",");
        }
        writer.println();
        for (MatrixRow cr : this.constraints) {
            int col = 0;
            List<MatrixElement> rowels = Arrays.asList(cr.elements().toArray(new MatrixElement[0]));
            Collections.sort(rowels);
            writer.print(cr.tag + "," + (Object)((Object)cr.type) + "," + cr.lowerBound + "," + cr.upperBound + ",");
            for (MatrixElement next : rowels) {
                if (next.colIndex < col) {
                    throw new Error("not sorted " + col + " " + next.colIndex);
                }
                while (col < next.colIndex) {
                    writer.print(", ");
                    ++col;
                }
                writer.print(next.value);
            }
            writer.println();
        }
        writer.flush();
    }

    public class PrimitiveMatrix {
        public double[] solution = null;
        public double[] structure = null;
        public double[] matrixElements = null;
        public int[] matrixRowIndexes = null;
        public int[] matrixColIndexes = null;
        public double[] columnBounds = null;
        public double[] rowBounds = null;
        public int[] columnBoundTypes = null;
        public int[] rowBoundTypes = null;
        public int[] columnTypes = null;
        public char[][] rowNames = null;
        public char[][] colNames = null;
        boolean structureChanged = true;
        boolean constraintsChanged = true;

        public void acceptChanges() {
            this.structureChanged = false;
            this.constraintsChanged = false;
        }

        public PrimitiveMatrix(Matrix matrix2) {
            this.fullReset(matrix2);
        }

        public void fullReset(Matrix matrix) {
            this.solution = new double[matrix.variables.size()];
            this.structure = new double[matrix.variables.size()];
            int totalNumElements = matrix.totalNumElements();
            this.matrixElements = new double[totalNumElements];
            this.matrixRowIndexes = new int[totalNumElements];
            this.matrixColIndexes = new int[totalNumElements];
            this.columnBounds = new double[this.structure.length * 2];
            this.rowBounds = new double[matrix.constraints.size() * 2];
            this.columnBoundTypes = new int[this.structure.length];
            this.rowBoundTypes = new int[matrix.constraints.size()];
            this.columnTypes = new int[this.structure.length];
            this.rowNames = new char[matrix.constraints.size()][];
            this.colNames = new char[matrix.variables.size()][];
            for (MatrixVariable cv : Matrix.this.variables) {
                this.setVariable(cv);
            }
            int element = 0;
            for (int row = 0; row < this.rowBoundTypes.length; ++row) {
                MatrixRow cr = (MatrixRow)matrix.constraints.get(row);
                for (MatrixElement currel : cr.elements()) {
                    this.matrixElements[element] = currel.value;
                    if (currel.value == 0.0) {
                        throw new Error("Zero matrix element" + row + " of " + this.rowBoundTypes.length);
                    }
                    this.matrixRowIndexes[element] = row;
                    this.matrixColIndexes[element] = currel.colIndex;
                    ++element;
                }
                this.rowBounds[row * 2] = cr.lowerBound;
                this.rowBounds[row * 2 + 1] = cr.upperBound;
                this.rowBoundTypes[row] = cr.type.toCPP();
                this.rowNames[row] = cr.tag.toCharArray();
            }
            this.structureChanged = true;
            this.constraintsChanged = true;
        }

        void updateCoefficients() {
            for (MatrixVariable cv : Matrix.this.variables) {
                this.setVariable(cv);
            }
            this.structureChanged = true;
        }

        void setVariable(MatrixVariable cv) {
            this.structure[cv.column()] = 0.0;
            for (Types.ObjectiveType ot : cv.objectivesSet()) {
                int n = cv.column();
                this.structure[n] = this.structure[n] + cv.getCoefficientForObjective(ot) * ((Objective)Matrix.this.objectives.get((Object)ot)).scaleFactor();
            }
            this.columnBounds[cv.column() * 2] = cv.lowerBound;
            this.columnBounds[cv.column() * 2 + 1] = cv.upperBound;
            this.columnBoundTypes[cv.column()] = cv.boundType.toCPP();
            this.columnTypes[cv.column()] = cv.varType.toCPP();
            this.colNames[cv.column()] = cv.tag().toCharArray();
            this.structureChanged = true;
        }

        void commitSolution() {
            for (Objective obj : Matrix.this.objectives.values()) {
                for (MatrixVariable var : obj.variables()) {
                    var.setSolution(this.solution[var.column()]);
                }
            }
        }

        public double getObjectiveValue(Types.ObjectiveType type) {
            Objective obj = (Objective)Matrix.this.objectives.get((Object)type);
            double oval = 0.0;
            for (MatrixVariable var : obj.variables()) {
                oval += var.getCoefficientForObjective(type) * this.solution[var.column()];
            }
            return oval;
        }

        public double getObjectiveValue() {
            double oval = 0.0;
            for (Objective obj : Matrix.this.objectives.values()) {
                oval += this.getObjectiveValue(obj.type);
            }
            return oval;
        }
    }
}

