/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math.MathException;
import org.apache.commons.math.util.DefaultTransformer;
import org.apache.commons.math.util.NumberTransformer;

public class TransformerMap
implements NumberTransformer,
Serializable {
    private static final long serialVersionUID = -942772950698439883L;
    private NumberTransformer defaultTransformer = null;
    private Map map = new HashMap();

    public TransformerMap() {
        this.defaultTransformer = new DefaultTransformer();
    }

    public boolean containsClass(Class key) {
        return this.map.containsKey(key);
    }

    public boolean containsTransformer(NumberTransformer value) {
        return this.map.containsValue(value);
    }

    public NumberTransformer getTransformer(Class key) {
        return (NumberTransformer)this.map.get(key);
    }

    public Object putTransformer(Class key, NumberTransformer transformer) {
        return this.map.put(key, transformer);
    }

    public Object removeTransformer(Class key) {
        return this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }

    public Set classes() {
        return this.map.keySet();
    }

    public Collection transformers() {
        return this.map.values();
    }

    public double transform(Object o) throws MathException {
        double value = Double.NaN;
        if (o instanceof Number || o instanceof String) {
            value = this.defaultTransformer.transform(o);
        } else {
            NumberTransformer trans = this.getTransformer(o.getClass());
            if (trans != null) {
                value = trans.transform(o);
            }
        }
        return value;
    }
}

