\name{dvisits}
\alias{dvisits}
\docType{data}
\title{Doctor visits in Australia}
\description{
The data come
from the Australian Health Survey of 1977-78 and consist of 5190
single adults where young and old have been oversampled.
}
\usage{data(dvisits)}
\format{
  A data frame with 5190 observations on the following 19 variables.
  \describe{
    \item{\code{sex}}{1 if female, 0 if male}
    \item{\code{age}}{Age in years divided by 100
           (measured as mid-point of 10 age groups from 15-19 years to
            65-69 with 70 or more coded treated as 72)}
    \item{\code{agesq}}{age squared}
    \item{\code{income}}{Annual income in Australian dollars divided by 1000
           (measured as mid-point of coded ranges Nil, less than 200, 200-1000,
            1001-, 2001-, 3001-, 4001-, 5001-, 6001-, 7001-, 8001-10000,
            10001-12000, 12001-14000, with 14001- treated as 15000 }
    \item{\code{levyplus}}{1 if covered by private health insurance fund for private
           patient in public hospital (with doctor of choice), 0 otherwise}
    \item{\code{freepoor}}{1 if covered by government because low income, recent immigrant,
           unemployed, 0 otherwise}
    \item{\code{freerepa}}{1 if covered free by government because of old-age or disability
           pension, or because invalid veteran or family of deceased 
           veteran, 0 otherwise}
    \item{\code{illness}}{Number of illnesses in past 2 weeks with 5 or more coded as 5}
    \item{\code{actdays}}{Number of days of reduced activity in past two weeks due to 
           illness or injury}
    \item{\code{hscore}}{General health questionnaire score using Goldberg's method.
           High score indicates bad health}
    \item{\code{chcond1}}{1 if chronic condition(s) but not limited in activity, 0 otherwise}
    \item{\code{chcond2}}{1 if chronic condition(s) and limited in activity, 0 otherwise}
    \item{\code{doctorco}}{Number of consultations with a doctor or specialist 
          in the past 2 weeks}
    \item{\code{nondocco}}{Number of consultations with non-doctor health professionals
          (chemist, optician, physiotherapist, social worker, 
           district community nurse, chiropodist or chiropractor)
           in the past 2 weeks}
    \item{\code{hospadmi}}{Number of admissions to a hospital, psychiatric hospital, 
          nursing or convalescent home in the past 12 months 
          (up to 5 or more admissions which is coded as 5)}
    \item{\code{hospdays}}{Number of nights in a hospital, etc. during most recent
          admission: taken, where appropriate, as the mid-point of the
          intervals 1, 2, 3, 4, 5, 6, 7, 8-14, 15-30, 31-60, 61-79
          with 80 or more admissions coded as 80. If no admission
          in past 12 months then equals zero}
    \item{\code{medicine}}{Total number of prescribed and nonprescribed medications used
          in past 2 days}
    \item{\code{prescrib}}{Total number of prescribed medications used in past 2 days}
    \item{\code{nonpresc}}{Total number of nonprescribed medications used in past 2 days}
  }
}
\source{
  Cameron A, Trivedi P, Milne F and Piggot J (1988) A Microeconometric
  model of the demand for health care and health insurance in Australia,
  Review of Economic Studies 55, 85-106
}
\keyword{datasets}
