% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationFeatureExpression.R
\name{extract_feature_expression}
\alias{extract_feature_expression}
\title{Internal function to extract feature expressions.}
\usage{
extract_feature_expression(
  object,
  data,
  feature_similarity,
  sample_similarity,
  feature_cluster_method = waiver(),
  feature_linkage_method = waiver(),
  feature_similarity_metric = waiver(),
  sample_cluster_method = waiver(),
  sample_linkage_method = waiver(),
  sample_similarity_metric = waiver(),
  evaluation_times = waiver(),
  message_indent = 0L,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{familiarEnsemble} object, which is an ensemble of one or more
\code{familiarModel} objects.}

\item{data}{A \code{dataObject} object, \code{data.table} or \code{data.frame} that
constitutes the data that are assessed.}

\item{feature_similarity}{Table containing pairwise distance between
sample. This is used to determine cluster information, and indicate which
samples are similar. The table is created by the
\code{extract_sample_similarity} method.}

\item{feature_cluster_method}{The method used to perform clustering. These are
the same methods as for the \code{cluster_method} configuration parameter:
\code{none}, \code{hclust}, \code{agnes}, \code{diana} and \code{pam}.

\code{none} cannot be used when extracting data regarding mutual correlation or
feature expressions.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_linkage_method}{The method used for agglomerative clustering in
\code{hclust} and \code{agnes}. These are the same methods as for the
\code{cluster_linkage_method} configuration parameter: \code{average}, \code{single},
\code{complete}, \code{weighted}, and \code{ward}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_similarity_metric}{Metric to determine pairwise similarity
between features. Similarity is computed in the same manner as for
clustering, and \code{feature_similarity_metric} therefore has the same options
as \code{cluster_similarity_metric}: \code{mcfadden_r2}, \code{cox_snell_r2},
\code{nagelkerke_r2}, \code{spearman}, \code{kendall} and \code{pearson}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{sample_cluster_method}{The method used to perform clustering based on
distance between samples. These are the same methods as for the
\code{cluster_method} configuration parameter: \code{hclust}, \code{agnes}, \code{diana} and
\code{pam}.

\code{none} cannot be used when extracting data for feature expressions.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{sample_linkage_method}{The method used for agglomerative clustering in
\code{hclust} and \code{agnes}. These are the same methods as for the
\code{cluster_linkage_method} configuration parameter: \code{average}, \code{single},
\code{complete}, \code{weighted}, and \code{ward}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{sample_similarity_metric}{Metric to determine pairwise similarity
between samples. Similarity is computed in the same manner as for
clustering, but \code{sample_similarity_metric} has different options that are
better suited to computing distance between samples instead of between
features: \code{gower}, \code{euclidean}.

The underlying feature data is scaled to the \eqn{[0, 1]} range (for
numerical features) using the feature values across the samples. The
normalisation parameters required can optionally be computed from feature
data with the outer 5\% (on both sides) of feature values trimmed or
winsorised. To do so append \verb{_trim} (trimming) or \verb{_winsor} (winsorising) to
the metric name. This reduces the effect of outliers somewhat.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{evaluation_times}{One or more time points that are used for in analysis of
survival problems when data has to be assessed at a set time, e.g.
calibration. If not provided explicitly, this parameter is read from
settings used at creation of the underlying \code{familiarModel} objects. Only
used for \code{survival} outcomes.}

\item{message_indent}{Number of indentation steps for messages shown during
computation and extraction of various data elements.}

\item{verbose}{Flag to indicate whether feedback should be provided on the
computation and extraction of various data elements.}

\item{...}{Unused arguments.}
}
\value{
A list with a data.table containing feature expressions.
}
\description{
Computes and extracts feature expressions for features
used in a \code{familiarEnsemble} object.
}
\keyword{internal}
