% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_process_data.R
\name{pre_process_data}
\alias{pre_process_data}
\title{Pre-process data}
\usage{
pre_process_data(data, protected, y, type = "resample_uniform", ...)
}
\arguments{
\item{data}{\code{data.frame}}

\item{protected}{factor, protected attribute (sensitive variable) containing information about gender, race etc...}

\item{y}{numeric, numeric values of predicted variable. 1 should denote favorable outcome.}

\item{type}{character, type of pre-processing algorithm to be used, one of:
\itemize{
\item{resample_uniform}
\item{resample_preferential}
\item{reweight}
\item{disparate_impact_remover}
}}

\item{...}{other parameters passed to pre-processing algorithms}
}
\value{
modified data (\code{data.frame}). In case of type = 'reweight' data has feature `_weights_` containing weights that need to be passed to model.
In other cases data is ready to be passed as training data to a model.
}
\description{
Function aggregates all pre-processing algorithms for bias mitigation. User passes unified arguments and specifies type to receive transformed \code{data.frame}
}
\examples{
data("german")

pre_process_data(german,
                 german$Sex,
                 as.numeric(german$Risk)-1,
                 type = "disparate_impact_remover",
                 features_to_transform = 'Age')
}
