% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvdraws.R
\name{predloglik}
\alias{predloglik}
\title{Evaluates the predictive log likelihood using the predicted
covariance matrix}
\usage{
predloglik(
  x,
  y,
  ahead = 1,
  each = 1,
  alldraws = FALSE,
  indicator = rep(TRUE, ncol(y))
)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{y}{Matrix of dimension \code{length(ahead)} times \code{m} where the
predictive density should be evaluated.}

\item{ahead}{Vector of timepoints, indicating how many steps
to predict ahead.}

\item{each}{Single integer (or coercible to such) indicating how
often should be drawn from the posterior predictive distribution
for each draw that has been stored during MCMC sampling.}

\item{alldraws}{Should all the draws be returned or just the final results?
(Can be useful to assess convergence.)}

\item{indicator}{Logical vector of length \code{m} indicating which
component series should be evaluated. The default is to evaluate
all of them.}
}
\value{
Vector of length \code{length(ahead)} with log predictive
likelihoods.
}
\description{
\code{predloglik} approximates the predictive log likelihood by
simulating from the predictive distribution of the covariance
matrix and evaluating the corresponding multivariate normal
distribution.
}
\examples{
\donttest{
set.seed(1)

# Simulate a time series of length 1100:
sim <- fsvsim(n = 1100, series = 3, factors = 1)
y <- sim$y

# Estimate using only 1000 days:
res <- fsvsample(y[seq_len(1000),], factors = 1)

# Evaluate the 1, 10, and 100 days ahead predictive log
# likelihood:
ahead <- c(1, 10, 100)
scores <- predloglik(res, y[1000+ahead,], ahead = ahead, each = 10)
print(scores)
}

}
\seealso{
Uses \code{\link{predcov}}. If \code{m} is large
but only few factors are used, consider also using
\code{\link{predloglikWB}}.

Other predictors: 
\code{\link{predcond}()},
\code{\link{predcor}()},
\code{\link{predcov}()},
\code{\link{predh}()},
\code{\link{predloglikWB}()},
\code{\link{predprecWB}()}
}
\concept{predictors}
