% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorMergerClasses.R
\name{mergeFactors}
\alias{mergeFactors}
\alias{mergeFactor.default}
\title{Merge factors}
\usage{
mergeFactors(response, factor, ...)
}
\arguments{
\item{response}{A response \code{vector/matrix} suitable for the model family or a formula containing columns names from the \code{data} argument or formula.}

\item{factor}{A factor \code{vector} when we use \code{response} argument, otherwise the name of column from \code{data} argument containing which levels should be merged.}

\item{...}{Other arguments corresponding to type of first argument}
}
\description{
Performs step-wise merging of factor levels.
}
\examples{
rSample <- generateMultivariateSample(N = 100, k = 10, d = 3)

rSample$covariates <- runif(100)
rSample$weights <- runif(100)
mergeFactors(response = rSample$response, factor = rSample$factor)
mergeFactors(response = rSample$response, factor = rSample$factor, 
    covariates = rSample$covariates)
mergeFactors(rSample$response[,1], rSample$factor, 
    covariates = rSample$covariates, weights = rSample$weights)
dataset <- cbind(rSample$response, rSample$factor, rSample$covariates)
colnames(dataset) <- c("res1","res2","res3","fct", "cov1")

formula <- as.formula("res1+res2+res3~fct")
formulaCovariates <-as.formula("res1+res2+res3~fct+cov1")
mergeFactors(response = formula, factor="fct", data=dataset)
mergeFactors(response = formulaCovariates, factor="fct", data=dataset)

}
