% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.3dplot.R
\name{net.3dplot}
\alias{net.3dplot}
\title{3D network plot of an adjacency matrix between pairs of change points}
\usage{
net.3dplot(A, ROIs = NULL, colors = NULL, coordROIs = NULL)
}
\arguments{
\item{A}{An adjacency matrix to be plotted (in numerical matrix format).}

\item{ROIs}{Either a vector of character strings specifying the communities to plot, or a vector of integers specifying which ROIs to plot by their ID. By
default it is set to NULL, and all communities and ROIs are plotted. Communities available for the Gordon atlas are: "Default", "SMhand", "SMmouth",
"Visual", "FrontoParietal", "Auditory", "None", "CinguloParietal", "RetrosplenialTemporal", "CinguloOperc", "VentralAttn", "Salience", and "DorsalAttn".}

\item{colors}{A vector of character strings specifying the hex codes for node colors to distinguish each community. By default, each community is given
a predefined, unique color.}

\item{coordROIs}{A dataframe of community tags and Montreal Neurological Institute (MNI) coordinates for regions of interest (ROIs) to plot, which is by
default set to \code{NULL} and uses the Gordon atlas. See ?gordon.atlas for an example using the Gordon atlas. Format of the dataframe is as follows: first column
is a string of community labels, then the subsequent three columns are the x, y, and z coordinates, respectively. See \code{AALatlas} and \code{gordatlas}
for examples.}
}
\value{
A 3D network plot of an adjacency matrix between pairs of change points, or for data without change points.
}
\description{
This function takes an adjacency matrix of a brain network and returns a 3D plot of it.
}
\examples{
\donttest{
## Plotting a 333 * 333 adjacency matrix "adjmatrix" with red, blue, and green
## nodes to denote the "Default", "SMhand", and "Visual" communities
comms = c("Default", "SMhand", "Visual")
colrs = c("#FF0000", "#00FF00", "#0000FF")
net.3dplot(adjmatrix, ROIs = comms, colors = colrs)
}

}
\references{
"Factorized Binary Search: a novel technique for change point detection in multivariate high-dimensional time series networks", Ondrus et al.
(2021), <arXiv:2103.06347>.
}
\author{
Martin Ondrus, \email{mondrus@ualberta.ca}, Ivor Cribben, \email{cribben@ualberta.ca}
}
