% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-utils.R
\name{read_excel_allsheets}
\alias{read_excel_allsheets}
\title{Read all Excel sheets using \code{\link[readxl:read_excel]{readxl::read_excel()}} recursively}
\usage{
read_excel_allsheets(filename, sheets = "")
}
\arguments{
\item{filename}{A character string of the path of the Excel file.}

\item{sheets}{A vector containing only the sheets to be read.}
}
\value{
A list of tibbles corresponding to the sheets read, or a single tibble
if the number of sheets is one.
}
\description{
The Excel file is read and the values are placed in a list of tibbles, with
each sheet in a separate element in the list. If the Excel file has only one
sheet, the output is a single tibble.
}
\examples{
{

try(read_excel_allsheets(filename = tempfile()), silent = TRUE)

}

}
\seealso{
\code{\link[readxl:read_excel]{readxl::read_excel()}}
}
