% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-file_index.R
\name{file_index_search}
\alias{file_index_search}
\title{Search an index of files}
\usage{
file_index_search(
  index,
  file_path = "^",
  file_name = "^",
  extension = "^",
  file_type = "^",
  show_tree = FALSE
)
}
\arguments{
\item{index}{The index (tibble) of a folder with file locations and metadata,
either previously generated by file_index_create() or created from folder.}

\item{file_path}{A character string specifying a file path to search by.
Can be the full string or substring (matching by regex is supported)}

\item{file_name}{A character string a file name to search by.
Can be the full string or substring (matching by regex is supported).}

\item{extension}{A character string a file extension to search by.
Can be the full string or substring (matching by regex is supported).}

\item{file_type}{A character string a file type to search by.
Can be the full string or substring (matching by regex is supported).}

\item{show_tree}{If TRUE, return the file tree of the query.}
}
\value{
A tibble with indexed information for files matching the query.
}
\description{
Searches in file index R object (tibble) based on pattern and other query
options and provides a table where all the files in a specified folder and
corresponding to the query are listed (recursively). If no index tibble is
provided, the function creates one from the working directory.
}
\details{
The function displays the tree of your files. You can enable this
functionality with 'show_tree = TRUE'
}
\examples{
\dontrun{

index <- file_index_create(tempdir())
file_index_search(index, file_name = my_file_name)

}

}
