% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCT_FFT_detrending.R
\name{detrend}
\alias{detrend}
\title{Detrending with DCT or FFT}
\usage{
detrend(X, TR, f = 0.008, method = c("DCT", "FFT"))
}
\arguments{
\item{X}{A numeric matrix, with each column being a timeseries to detrend.
For fMRI data, \code{X} should be \code{T} timepoints by \code{V} brain
locations.}

\item{TR}{The time step between adjacent rows of \code{X}, in seconds}

\item{f}{The frequency of the highpass filter, in Hertz. Default: \code{.008}}

\item{method}{\code{"DCT"} (default) or \code{"FFT"}.}
}
\value{
Detrended \code{X}
}
\description{
Detrending with DCT or FFT
}
\examples{
detrend(matrix(rnorm(700), nrow=100), TR=.72)
}
