% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandstop_filter.R
\name{bandstop_filter}
\alias{bandstop_filter}
\title{Bandstop filter}
\usage{
bandstop_filter(x, TR, f1, f2, Rs = 20)
}
\arguments{
\item{x}{A numeric matrix, with each column being a timeseries to apply
the stopband filter}

\item{TR}{the time difference between rows in x, in seconds.}

\item{f1, f2}{The frequency limits for the filter, in Hz. \code{f1 < f2}.}

\item{Rs}{The amount of attenuation of the stopband ripple, in dB}
}
\value{
The filtered data
}
\description{
Filter out frequencies within a given range using a Chebyshev Type II
stopband. Basically a convenience wrapper for the \code{gsignal::cheby2}
function.
}
\examples{
if (requireNamespace("gsignal", quietly = TRUE)) {
 n_voxels = 1e4
 n_timepoints = 100
 X = cbind(arima.sim(n=100, list(ar=.6)), arima.sim(n=100, list(ar=.6)))
 Y = bandstop_filter(X, .72, .31, .43)
}
}
