% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_initial_values.R
\name{get_initial_values}
\alias{get_initial_values}
\title{Initialization of numerical likelihood optimization}
\usage{
get_initial_values(
  data,
  ncluster = 1,
  seed = NULL,
  verbose = TRUE,
  initial_estimate = NULL
)
}
\arguments{
\item{data}{An object of class \code{\link{fHMM_data}}.}

\item{ncluster}{Set the number of clusters for parallel optimization runs to reduce
optimization time.
By default, \code{ncluster = 1} (no clustering).}

\item{seed}{Set a seed for the generation of initial values.
No seed by default.}

\item{verbose}{Set to \code{TRUE} to print progress messages.}

\item{initial_estimate}{Optionally defines an initial estimate for the numerical likelihood
optimization. Good initial estimates can improve the optimization process.
Can be:
\itemize{
\item \code{NULL} (the default), in this case
\itemize{
\item applies a heuristic to calculate a good initial estimate
\item or uses the true parameter values (if available and
\code{data$controls$origin} is \code{TRUE})
}
\item or an object of class \code{parUncon} (i.e., a \code{numeric} of
unconstrained model parameters), for example the estimate of a
previously fitted model (i.e. the element \code{model$estimate}).
}}
}
\value{
A \code{list}, where each element is an object of class \code{parUncon}.
}
\description{
This helper function generates a set of initial values for the numerical
optimization of the model likelihood function.
}
\keyword{internal}
