% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Model fitting}
\usage{
fit_model(
  data,
  controls = data[["controls"]],
  fit = list(),
  runs = 10,
  origin = FALSE,
  accept = 1:3,
  gradtol = 0.01,
  iterlim = 100,
  print.level = 0,
  steptol = 0.01,
  ncluster = 1,
  seed = NULL,
  verbose = TRUE,
  initial_estimate = NULL
)
}
\arguments{
\item{data}{An object of class \code{\link{fHMM_data}}.}

\item{controls}{Either a \code{list} or an object of class \code{fHMM_controls}.

The \code{list} can contain the following elements, which are described
in more detail below:
\itemize{
\item \code{hierarchy}, defines an hierarchical HMM,
\item \code{states}, defines the number of states,
\item \code{sdds}, defines the state-dependent distributions,
\item \code{horizon}, defines the time horizon,
\item \code{period}, defines a flexible, periodic fine-scale time horizon,
\item \code{data}, a \code{list} of controls that define the data,
\item \code{fit}, a \code{list} of controls that define the model fitting
}
Either none, all, or selected elements can be specified.

Unspecified parameters are set to their default values.

Important: Specifications in \code{controls} always override individual
specifications.}

\item{fit}{A \code{list} of controls specifying the model fitting.

The \code{list} can contain the following elements, which are described
in more detail below:
\itemize{
\item \code{runs}, defines the number of numerical optimization runs,
\item \code{origin}, defines initialization at the true parameters,
\item \code{accept}, defines the set of accepted optimization runs,
\item \code{gradtol}, defines the gradient tolerance,
\item \code{iterlim}, defines the iteration limit,
\item \code{print.level}, defines the level of printing,
\item \code{steptol}, defines the minimum allowable relative step length.
}
Either none, all, or selected elements can be specified.

Unspecified parameters are set to their default values, see below.

Specifications in \code{fit} override individual specifications.}

\item{runs}{An \code{integer}, setting the number of randomly initialized
optimization runs of the model likelihood from which the best one is selected
as the final model.

By default, \code{runs = 10}.}

\item{origin}{Only relevant for simulated data, i.e., if the \code{data} control is
\code{NA}.

In this case, a \code{logical}. If \code{origin = TRUE} the optimization is
initialized at the true parameter values.
This sets \code{run = 1} and \code{accept = 1:5}.

By default, \code{origin = FALSE}.}

\item{accept}{An \code{integer} (vector), specifying which optimization runs are
accepted based on the output code of \code{\link[stats]{nlm}}.

By default, \code{accept = 1:3}.}

\item{gradtol}{A positive \code{numeric} value, specifying the gradient tolerance, passed on
to \code{\link[stats]{nlm}}.

By default, \code{gradtol = 0.01}.}

\item{iterlim}{A positive \code{integer} value, specifying the iteration limit, passed on
to \code{\link[stats]{nlm}}.

By default, \code{iterlim = 100}.}

\item{print.level}{One of \code{0}, \code{1}, and \code{2} to control the verbosity of the
numerical likelihood optimization, passed on to \code{\link[stats]{nlm}}.

By default, \code{print.level = 0}.}

\item{steptol}{A positive \code{numeric} value, specifying the step tolerance, passed on
to \code{\link[stats]{nlm}}.

By default, \code{gradtol = 0.01}.}

\item{ncluster}{Set the number of clusters for parallel optimization runs to reduce
optimization time.
By default, \code{ncluster = 1} (no clustering).}

\item{seed}{Set a seed for the generation of initial values.
No seed by default.}

\item{verbose}{Set to \code{TRUE} to print progress messages.}

\item{initial_estimate}{Optionally defines an initial estimate for the numerical likelihood
optimization. Good initial estimates can improve the optimization process.
Can be:
\itemize{
\item \code{NULL} (the default), in this case
\itemize{
\item applies a heuristic to calculate a good initial estimate
\item or uses the true parameter values (if available and
\code{data$controls$origin} is \code{TRUE})
}
\item or an object of class \code{parUncon} (i.e., a \code{numeric} of
unconstrained model parameters), for example the estimate of a
previously fitted model (i.e. the element \code{model$estimate}).
}}
}
\value{
An object of class \code{\link{fHMM_model}}.
}
\description{
This function fits a hidden Markov model via numerical likelihood
maximization.
}
\details{
Multiple optimization runs starting from different initial values are
computed in parallel if \code{ncluster > 1}.
}
\examples{
### 2-state HMM with normal distributions

# set specifications
controls <- set_controls(
  states = 2, sdds = "normal", horizon = 100, runs = 10
)

# define parameters
parameters <- fHMM_parameters(controls, mu = c(-1, 1), seed = 1)

# sample data
data <- prepare_data(controls, true_parameter = parameters, seed = 1)

# fit model
model <- fit_model(data, seed = 1)

# inspect fit
summary(model)
plot(model, "sdds")

# decode states
model <- decode_states(model)
plot(model, "ts")

# predict
predict(model, ahead = 5)

}
