% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting-functions.R
\name{predict,fEGarch_fit-method}
\alias{predict,fEGarch_fit-method}
\alias{predict_roll,fEGarch_fit-method}
\title{Multistep and Rolling Point Forecasts}
\usage{
\S4method{predict}{fEGarch_fit}(object, n.ahead = 10, trunc = NULL, ...)

\S4method{predict_roll}{fEGarch_fit}(object, step_size = 1, trunc = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{"fEGarch_fit"},
i.e. an object returned by either \code{\link{fEGarch}},
\code{\link{fiaparch}} or \code{\link{figarch}}, etc.; for
\code{predict_roll}, the slot \code{@test_obs} of the
fitted model object should not be \code{NULL}.}

\item{n.ahead}{a single numeric value indicating how
far into the future the multistep point forecasts should be
produced.}

\item{trunc}{the truncation setting for the infinite-order
polynomial of long-memory model parts; the default uses
the setting from the fitted input object \code{object}.}

\item{...}{currently without use and included for compatibility
with generics.}

\item{step_size}{the step size of the rolling point
forecasts; by default, \code{step_size = 1} is employed,
i.e. for the immediately subsequent observation time
point for the entire test set.}
}
\value{
Returns an object of class \code{"fEGarch_forecast"} that has the
two slots \code{@sigt} and \code{@cmeans} representing the
forecasted conditional standard deviations and conditional
means, respectively. If the training series saved in \code{object}
has a special time series formatting like \code{"zoo"} or \code{"ts"},
the formatting is adopted accordingly to these numeric
output series. A third slot \code{@model} is the fitted model
input object \code{object}.
}
\description{
Given a fitted model object from this package, conduct
either multistep point forecasts of the conditional
means and the conditional standard deviations into
the future or rolling point forecasts of arbitrary
step size of these quantities for a future test set.
}
\details{
Use \code{predict} to compute multistep point forecasts
(of the conditional mean and of the conditional standard deviation)
into the future. Let \code{n} be the number of observations
of the data, to which a model was fitted. Then multistep
point forecasts are produced for all future time points
from \code{n + 1} to \code{n + n.ahead}.

Otherwise, if data was reserved for testing when creating
\code{object}, e.g. through the use of the argument
\code{n_test} in the corresponding functions, compute
rolling point forecasts over the test set using \code{predict_roll}.
\code{step_size} then determines the forecasting horizon for
the rolling point forecasts. For example, \code{step_size = 1}, i.e.
the default, computes one-step rolling point forecasts, whereas for
example \code{step_size = 10} computes ten-step rolling point
forecasts (starting at the tenth test time point).

Refitting of models during the rolling point forecast procedure
is currently not yet available.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2002-12-31")

# Multistep forecasting (EGARCH with cond. normal distr.)
model1 <- fEGarch(spec = egarch_spec(), rt)
fcast1 <- predict(model1, n.ahead = 10)
fcast1

# Rolling one-step forecasts (EGARCH with cond. normal distr.)
model2 <- fEGarch(spec = egarch_spec(), rt, n_test = 250)
fcast2 <- predict_roll(model2, step_size = 1)
fcast2

}
