% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-egarch-spec.R
\name{fEGarch_spec}
\alias{fEGarch_spec}
\title{General EGARCH Family Model Specification}
\usage{
fEGarch_spec(
  model_type = c("egarch", "loggarch"),
  orders = c(1, 1),
  long_memo = FALSE,
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald"),
  powers = c(1, 1),
  modulus = c(FALSE, FALSE)
)
}
\arguments{
\item{model_type}{a character value (either \code{"egarch"} or
\code{"loggarch"}) that indicates the type of model to
implement (see Details for more information).}

\item{orders}{a two-element numeric vector with the model
orders; the first element is the order \eqn{p} for the term based on
\eqn{\ln\left(\sigma_t^2\right)}, i.e. the log-transformed
conditional variance, while the second element is the order \eqn{q} for
the innovation-based term (see Details below for more information).}

\item{long_memo}{a logical value that indicates whether the
long-memory version of the model should be considered or not.}

\item{cond_dist}{a character value stating the underlying
conditional distribution to consider; available are a normal
distribution (\code{"norm"}), a \eqn{t}-distribution
(\code{"std"}), a generalized error distribution
(\code{"ged"}), an average Laplace distribution (\code{"ald"})
and the skewed versions of them
(\code{"snorm"}, \code{"sstd"}, \code{"sged"}, \code{"sald"}).}

\item{powers}{a two-element numeric vector that states the
exponents in the power-transformations of the asymmetry and the
magnitude terms in that order (see Details for more information).}

\item{modulus}{a two-element logical vector indicating if the
innovations in the asymmetry and the magnitude terms (in that
order) should use a modulus transformation (see Details for
more information).}
}
\value{
An object of either class \code{"egarch_type_spec"} or
\code{"loggarch_type_spec"} is returned, depending on the
choice for the input argument \code{model_type}.
}
\description{
Create an object with specifications for a model from
the broader EGARCH family.
}
\details{
Let \eqn{\left\{r_t\right\}}, with \eqn{t \in \mathbb{Z}} as the
time index, be a theoretical time series that follows
\deqn{r_t=\mu+\sigma_t \eta_t \text{ with } \eta_t \sim \text{IID}(0,1), \text{ where}}
\deqn{\ln\left(\sigma_t^2\right)=\omega_{\sigma}+\theta(B)g(\eta_{t-1}).}
Here, \eqn{\eta_t\sim\text{IID}(0,1)} means that the innovations
\eqn{\eta_t} are independent and identically distributed (iid) with mean zero
and variance one, whereas \eqn{\sigma_t > 0} are the conditional standard
deviations in \eqn{r_t}. Note that \eqn{\ln\left(\cdot\right)} denotes the natural logarithm.
Moreover, \eqn{B} is the backshift operator and
\eqn{\theta(B) = 1 +\sum_{i=1}^{\infty}\theta_i B^{i}}, where
\eqn{\theta_i}, \eqn{i=1,2,\dots}, are real-valued coefficients.
\eqn{g\left(\eta_{t-1}\right)} is a suitable function in \eqn{\eta_{t-1}}.
Generally, \eqn{\left\{g\left(\eta_{t}\right)\right\}} should be an iid
zero-mean sequence with finite variance.
We have \eqn{\mu = E\left(r_t\right)} as a real-valued parameter.
The real-valued parameter
\eqn{\omega_{\sigma}} is in fact
\eqn{\omega_{\sigma}=E\left[\ln\left(\sigma_t^2\right)\right]}.
This previous set of
equations defines the broader family of EGARCH models (Feng et al., 2025; Ayensu et al., 2025), from which
subtypes are described in the following that depend on the choice of
\eqn{g}.

\eqn{\textbf{Type I}:}

We have \eqn{\theta(B) = \phi^{-1}(B)(1-B)^{-d}\psi(B)}, where
\deqn{\phi(B) = 1-\sum_{i=1}^{p}\phi_{i}B^{i} \text{ and}}
\deqn{\psi(B) = 1+\sum_{j=1}^{q-1}\psi_{j}B^{j},}
are characteristic polynomials
with real coefficients \eqn{\phi_{0},\dots,\phi_{p},\psi_{0},\dots,\psi_{q-1}},
by fixing \eqn{\phi_{0}=\psi_{0}=1}, and without common roots. Furthermore,
the
fractional differencing parameter is \eqn{d \in [0,1]}.

\eqn{g\left(\cdot\right)} can be defined in different ways.
Following a type I specification (\code{model_type = "egarch"}), we have
\deqn{g\left(\eta_t\right)=\kappa \left\{g_a\left(\eta_t\right) - E\left[g_a\left(\eta_t\right)\right] \right\} + \gamma\left\{g_m\left(\eta_t\right)-E\left[ g_m\left(\eta_t\right)\right]\right\}}
with \eqn{g_a\left(\eta_t\right)} and \eqn{g_m\left(\eta_t\right)} being
suitable transformations of \eqn{\eta_t} and
where \eqn{\kappa} and \eqn{\gamma} are two additional real-valued
parameters. In case of a simple (FI)EGARCH, we have
\eqn{g_a\left(\eta_t\right) = \eta_t} (and therefore with
\eqn{E\left[g_a\left(\eta_t\right)\right] = 0}) and
\eqn{g_m\left(\eta_t\right) = \left|\eta_t \right|}.

Generally, we consider two cases:
\deqn{g_{1,a}\left(\eta_t\right)=\text{sgn}\left(\eta_t\right)\left|\eta_t\right|^{p_a}/p_a \text{ and}}
\deqn{g_{2,a}\left(\eta_t\right)=\text{sgn}\left(\eta_t\right)\left[\left(\left|\eta_t\right| + 1\right)^{p_a} - 1\right] / p_{a}}
whereas
\deqn{g_{1,m}\left(\eta_t\right)=\left|\eta_t\right|^{p_m}/p_m \text{ and}}
\deqn{g_{2,m}\left(\eta_t\right)=\left[\left(\left|\eta_t\right| + 1\right)^{p_m} - 1\right] / p_{m}.}
Note that \eqn{\text{sgn}\left(\eta_t\right)} denotes the sign of
\eqn{\eta_t}. \eqn{g_{1,\cdot}} incorporates a power transformation
and \eqn{g_{2,\cdot}} a modulus transformation together with a power
transformation. The choices
\eqn{g_{1,a}} and \eqn{g_{2,a}} correspond to
setting the first element in \code{modulus} to \code{FALSE} or
\code{TRUE}, respectively, under
\code{model_type = "egarch"}, where \eqn{p_a} can be selected
via the first element in \code{powers}. As a special case, for
\eqn{p_a = 0}, a log-transformation is employed and the division
through \eqn{p_a} is dropped, i.e.
\eqn{g_{1,a}\left(\eta_t\right)=\text{sgn}\left(\eta_t\right)\ln\left(\left|\eta_t\right|\right)}
and \eqn{g_{2,a}\left(\eta_t\right)=\text{sgn}\left(\eta_t\right)\ln\left(\left|\eta_t\right|+1\right)}
are employed for \eqn{p_a=0}. Completely analogous
thoughts hold for \eqn{g_{1,m}} and \eqn{g_{2,m}} and the second
elements in the arguments \code{modulus} and \code{powers}. The aforementioned
model family is a type I model selectable through
\code{model_type = "egarch"}. Simple (FI)EGARCH models are given through
selection of \eqn{g_{1,a}(\cdot)} and \eqn{g_{1,m}(\cdot)}
in combination with \eqn{p_a = p_m = 1}. Another of such type I models
is the FIMLog-GARCH (Feng et al., 2023), where instead
\eqn{g_{2,a}(\cdot)} and \eqn{g_{2,m}(\cdot)} are selected
with \eqn{p_a = p_m = 0}.

\eqn{\textbf{Type II}:}

As additional specifications of a Log-GARCH and a FILog-GARCH, which belong
to the broader EGARCH family, we redefine
\deqn{\psi(B) = 1+\sum_{j=1}^{q}\psi_{j}B^{j}}
now as a polynomial of order \eqn{q} and
\deqn{\ln\left(\sigma_t^2\right)=\omega_{\sigma}+\left[\phi^{-1}(B)(1-B)^{-d}\psi(B) - 1\right]\xi_t,}
where
\deqn{\xi_t=\ln\left(\eta_t^2\right)-E\left[\ln\left(\eta_t^2\right)\right].}
Everything else is defined as before. Since
\deqn{\phi^{-1}(B)(1-B)^{-d}\psi(B) - 1=\sum_{i=1}^{\infty}\gamma_i B^{i}=\gamma_1 B\left[\sum_{i=1}^{\infty}(\gamma_i/\gamma_1)B^{i-1}\right]=\gamma_1 B\left[1+\sum_{i=1}^{\infty}\theta_i B^{i}\right]=\theta(B)\gamma_1 B,}
where \eqn{\theta_i = \gamma_{i+1}/\gamma_{1}}, \eqn{i=0,1,\dots}, and by defining
\deqn{g\left(\eta_{t-1}\right)=\gamma_1\left\{\ln\left(\eta_{t-1}^2\right)-E\left[\ln\left(\eta_{t-1}^2\right)\right]\right\} = 2\gamma_1\left\{\ln\left(\left|\eta_{t-1}\right|\right)-E\left[\ln\left(\left|\eta_{t-1}\right|\right)\right]\right\},}
the equation of \eqn{\ln\left(\sigma_t^2\right)} can be stated to be
\deqn{\ln\left(\sigma_t^2\right)=\omega_{\sigma}+\theta(B)g(\eta_{t-1})}
as in the broad EGARCH family at the very beginning. Therefore, Log-GARCH
and FI-Log-GARCH models are equivalent to the type I models, where
\eqn{\kappa = 0} with usage of \eqn{g_{1,m}} with \eqn{p_m = 0} and where
\eqn{\gamma = 2\gamma_1}. Nonetheless,
in this package, the type II models make use of the more common
parameterization of \eqn{\ln\left(\sigma_t^2\right)} stated at the
beginning of the type II model description.

This describes the
established Log-GARCH models as part of the broad EGARCH family
(type II models; \code{model_type = "loggarch"}).

\eqn{\textbf{General information}:}

While the arguments \code{powers} and \code{modulus} are only relevant
under a type I model, i.e. for \code{model_type = "egarch"}, the arguments
\code{orders}, \code{long_memo} and \code{cond_dist} are
meaningful for both \code{model_type = "egarch"}
and \code{model_type = "loggarch"}, i.e. both under type I and II models.
The first element of the two-element vector orders is the order \eqn{p},
while the second element is the order \eqn{q}. Furthermore, for
\code{long_memo = TRUE}, the mentioned models are kept as they are, while
for \code{long_memo = FALSE} the parameter \eqn{d} is set to zero.
\code{cond_dist} controls the conditional distribution.
The unconditional mean \eqn{\mu} is controlled via the function
\code{\link{mean_spec}}; for \code{include_mean = FALSE} therein, \eqn{\mu} is not being estimated and fixed
to zero; its default is however \code{include_mean = TRUE}.

See also the closely related spec-functions that immediately create
specifications of specific submodels of the broad EGARCH family. These
functions are \code{egarch_spec()}, \code{fiegarch_spec()},
\code{loggarch_spec()},\code{filoggarch_spec()}, \code{megarch_spec()},
\code{mloggarch_spec()} and \code{mafiloggarch_spec()}, which are all
wrappers for \code{fEGarch_spec()}.

See the references section for sources on the EGARCH (Nelson, 1991),
FIEGARCH (Bollerslev and Mikkelsen, 1996),
Log-GARCH (Geweke, 1986; Pantula, 1986; Milhoj, 1987)
and FILog-GARCH (Feng et al., 2020) models.
}
\examples{
# EGARCH(1, 1) with cond. normal distribution
spec1 <- fEGarch_spec()
# EGARCH(2, 1) with cond. t-distribution
spec2 <- fEGarch_spec(orders = c(2, 1), cond_dist = "std")
# FIEGARCH(1, 1) with cond. normal distribution
spec3 <- fEGarch_spec(long_memo = TRUE)
# MEGARCH(1, 1) with cond. generalized error distribution
spec4 <- fEGarch_spec(modulus = c(TRUE, FALSE), powers = c(0, 1))
# Some unnamed specification
spec5 <- fEGarch_spec(
 model_type = "egarch",
 orders = c(1, 1),
 long_memo = TRUE,
 cond_dist = "std",
 powers = c(0.25, 0.75),
 modulus = c(TRUE, FALSE)
)

}
\references{
\itemize{
\item{Ayensu, O. K., Feng, Y., & Schulz, D. (2025). Recent Extensions of Exponential GARCH Models:
Theory and Application. Forthcoming preprint, Paderborn University.}
\item{Bollerslev, T., & Mikkelsen, H. O. (1996). Modeling and pricing long memory in stock market volatility. Journal of Econometrics,
73(1), 151–184. DOI: 10.1016/0304-4076(95)01749-6.}
\item{Feng, Y., Beran, J., Ghosh, S., & Letmathe, S. (2020). Fractionally integrated Log-GARCH with application to value at risk and expected shortfall.
Working Papers CIE No. 137, Paderborn University, Center for International Economics.
URL: http://groups.uni-paderborn.de/wp-wiwi/RePEc/pdf/ciepap/WP137.pdf.}
\item{Feng, Y., Gries, T., & Letmathe, S. (2023). FIEGARCH, modulus asymmetric FILog-GARCH
and trend-stationary dual long memory time series. Working Papers CIE No. 156, Paderborn University.
URL: https://econpapers.repec.org/paper/pdnciepap/156.htm.}
\item{Feng, Y., Peitz, C., & Siddiqui, S. (2025). A few useful members of the EGARCH-family
with short- or long-memory in volatility. Unpublished working paper at Paderborn University.}
\item{Geweke, J. (1986). Modeling the persistence of conditional variances: A comment. Econometric Reviews, 5(1),
57-61. DOI: 10.1080/07474938608800088.}
\item{Milhoj, A. (1987). A Multiplicative Parameterization of ARCH Models. University of Copenhagen, Denmark.}
\item{Nelson, D. B. (1991). Conditional Heteroskedasticity in Asset Returns: A New Approach. Econometrica,
59(2), 347–370. DOI: 10.2307/2938260.}
\item{Pantula, S. G. (1986). Modeling the persistence of conditional variances: A comment. Econometric Reviews, 5(1),
71-74. DOI: 10.1080/07474938608800089.}
}
}
