% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popular-methods.R
\name{sigma,fEGarch_fit-method}
\alias{sigma,fEGarch_fit-method}
\alias{sigma,fEGarch_forecast-method}
\title{Extract Fitted Conditional Standard Deviations}
\usage{
\S4method{sigma}{fEGarch_fit}(object)

\S4method{sigma}{fEGarch_forecast}(object)
}
\arguments{
\item{object}{an object either of class \code{"fEGarch_fit"} or
\code{"fEGarch_forecast"}.}
}
\value{
The element within the input object with name \code{sigt} is returned.
Depending on the element that can be a numeric vector, an object of
class "zoo" or a numeric matrix.
}
\description{
An alternative to \code{\link{sigt,fEGarch_fit-method}} to extract
fitted conditional standard deviations from an estimation object
in this package.
}
\details{
Extract fitted conditional standard deviations from an estimation object
in this package.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2002-12-31")
model <- fEGarch(egarch_spec(), rt, n_test = 250)
sigma(model)

}
