% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distr_est.R
\name{find_dist}
\alias{find_dist}
\title{Optimal Distribution Fitting to IID Data}
\usage{
find_dist(
  x,
  dists = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald"),
  fix_mean = NULL,
  fix_sdev = NULL,
  Prange = c(1, 5),
  criterion = c("bic", "aic")
)
}
\arguments{
\item{x}{the vector of iid values to fit distributions to.}

\item{dists}{a vector with all the distribution abbreviations which
should be considered in the selection process; by default, all eight
distributions of this package are considered.}

\item{fix_mean}{a value to fix the unconditional mean of the distribution to;
with the default \code{NULL}, the unconditional mean is estimated as an extra parameter.}

\item{fix_sdev}{a value to fix the unconditional standard deviation of the distribution to;
with the default \code{NULL}, the unconditional standard deviation is estimated as an extra parameter.}

\item{Prange}{a two-element vector giving the search range for the shape parameter
\eqn{P} of the (skewed) average Laplace distribution.}

\item{criterion}{either \code{"bic"} or \code{"aic"} to use BIC or AIC as
the final selection criterion; by default \code{"bic"} is implemented.}
}
\value{
Returns an object of class \code{"fEGarch_distr_est"} with various slots
representing the estimation results of the selected fitted distribution.
}
\description{
Given a series supposed to be from independent and identically distributed (iid)
random variables, fit all eight distributions of this package to the data
using maximum-likelihood estimation (MLE) and select the best one following
either the BIC (the default) or the AIC.
}
\details{
For information on the method and distributions, we refer the reader to
\code{\link{distr_est}}.
}
\examples{
x <- rnorm(2000) * 2.1 + 10.5
find_dist(x)

}
