% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfts.R
\name{dfts}
\alias{dfts}
\alias{as.dfts}
\alias{is.dfts}
\title{dfts Objects}
\usage{
dfts(X, name = NULL, labels = NULL, fparam = NULL, inc.warnings = TRUE)

as.dfts(X)

is.dfts(X)
}
\arguments{
\item{X}{Data to convert into dfts object. Options include: \link{data.frame},
\link{matrix}, \link{array}, \link[fda:fd]{fda::fd}, \link[fda.usc:fdata]{fda.usc::fdata}, \link[rainbow:fds]{rainbow::fts} (used in ftsa),
\link[rainbow:fds]{rainbow::fds} (used in ftsa), \link[funData:funData-class]{funData::funData}, and \link{dfts}. For a
matrix, each column is a unique observation, at the rows are the observed
intra-observation (i.e. resolution) points.}

\item{name}{String for the name of the object. Defaults to the name of the
input variable.}

\item{labels}{Labels for the observations. Defaults to the column names or
names inside of the object X.}

\item{fparam}{Vector of numerics indicating the points of evaluation for each
observation. Defaults to even spacing on [0,1], or those included in the
object. These may be unevenly spaced.}

\item{inc.warnings}{Boolean on if warnings should be given. Defaults to TRUE.}
}
\value{
dfts / as.dfts: dfts object

is.dfts: Boolean indicating if \code{x} is a dfts object or not
}
\description{
The discrete functional time series (dfts) object is the main object in
fChange. It stores functional data for use in functions throughout the package.
Common functions have been extended to dfts. Details of the storage is best
left to individual parameters descriptions and exploring examples.
}
\examples{
bm <- dfts(generate_brownian_motion(100, c(0,0.1,0.25,0.5,1)))

result <- dfts(electricity)
result <- as.dfts(electricity)
result <- is.dfts(electricity)
}
