% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_bandwidth.R
\name{opt_bandwidth}
\alias{opt_bandwidth}
\title{Optimal Bandwidth Selection for the Long Run Covariance Estimation}
\usage{
opt_bandwidth(fdobj, kern_type, kern_type_ini, is_change = TRUE, ...)
}
\arguments{
\item{fdobj}{Functional data object, class of \code{"fd"}}

\item{kern_type}{Kernel that is used for the long run covariance estimation. The available options are
\code{c("BT", "PR", "TH", "QS")} where \code{"BT"} is Bartlett, \code{"PR"} is Parzen, \code{"TH"} is Tukey-Hanning, and \code{"QS"} is Quadratic Spectral kernel.}

\item{kern_type_ini}{Initial Kernel function to start the optimal bandwidth search}

\item{is_change}{If \code{TRUE} then the data is centered considering the change in the mean function}

\item{...}{Further arguments to pass}
}
\value{
\item{\code{hat_h_opt}}{
Estimated optimal bandwidth
}
\item{\code{C_0_est}}{
Estimated Long run covariance kernel using the optimal bandwidth  \code{hat_h_opt}
}
}
\description{
This function estimates an optimal window parameter for long run covariance operator estimation  in functional time series using the method of Rice G. and Shang H. L. (2017)
}
\examples{
fdata1 = fun_AR(n=100, nbasis=21, order=1, kappa=0.8)
opt_bandwidth(fdata1, "PR", "BT")
}
\references{
Rice G. and Shang H. L. (2017), \emph{A plug-in bandwidth selection procedure for
long run covariance estimation with stationary functional time series}, Journal of Time Series Analysis, 38(4), 591-609
}
\seealso{
\code{\link{LongRun}}
}
