% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_component.R
\name{eval_component}
\alias{eval_component}
\title{Detecting Changes in the Eigenvalues of the Covariance Operator of the Functional Data}
\usage{
eval_component(fdobj, component, h = 2, mean_change = FALSE,
  delta = 0.1, M = 1000)
}
\arguments{
\item{fdobj}{A functional data object of class '\code{fd}'}

\item{component}{The eigenvalue that the componentwise test is applied to.}

\item{h}{The window parameter for the estimation of the long run covariance matrix. The default
value is \code{h=2}.}

\item{mean_change}{If \code{TRUE} then the data is centered considering the change in the mean function.}

\item{delta}{Trimming parameter to estimate the covariance function using partial sum estimates.}

\item{M}{Number of monte carlo simulations used to get the critical values. The default value is \code{M=1000}}
}
\value{
\item{\code{pvalue}}{
Approximate p value for testing whether there is a significant change in the desired eigenvalue of the covariance operator
}
\item{\code{change}}{
Estimated change location
}
}
\description{
This function tests and detects changes in the specific eigenvalue of the covariance operator.
}
\details{
This function dates and detects changes in the defined eigenvalue of the covariance function. The critical values are
approximated via \code{M} Monte Carlo simulations.
}
\examples{
# generate functional data
fdata = fun_IID(n=100, nbasis=21)
eval_component(fdata, 2)



}
