\name{generate.parameterDef}
\alias{generate.parameterDef}
\title{Generate Parameter}
\usage{
  \method{generate}{parameterDef}(x,...)
}
\arguments{
  \item{x}{A parameterDef Object}

  \item{\dots}{unused}
}
\value{
  \item{other_parameters}{A list of other_parameters}
  \item{scalar_parameters}{A data.frame of
  scalar_parameters} \item{parameter_list}{A list of all
  parameters}
}
\description{
  Generate Parameters from a parameterDef Object. The
  selection parameters in parameterDef is expanded and
  concatenated with the banker parameters.
}
\examples{
par_def1<-createParDef(selection=list(mean=1,sd=2,n=seq(10,50,10)))
generate(par_def1)
par_def2<-createParDef(selection=list(sd=2,mean=1:3,n=seq(10,50,10)))
generate(par_def2)
}
\author{
  TszKin Julian Chan \email{ctszkin@gmail.com}
}
\seealso{
  \code{\link{setBanker.parameterDef}},
  \code{\link{setSelection.parameterDef}},
  \code{\link{evalFunctionOnParameterDef}},
  \code{\link{generate.parameterDef}}
}

