% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterfall_plot.R
\name{waterfall_plot}
\alias{waterfall_plot}
\title{waterfall_plot}
\usage{
waterfall_plot(data, x, y, group, size = 14, labels = ez_labels,
  label_rescale = 1, y_min = "auto", rescale_y = 1.1, n_signif = 3,
  rotate_xlabel = FALSE, bottom_label = TRUE, ingroup_label = FALSE,
  n_x = 2)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{y}{A named character value. Evaluates to a column.}

\item{group}{A character value. Evaluates to a column.}

\item{size}{theme size for \code{use_theme()}. Default is 14.}

\item{labels}{Function for formatting labels.}

\item{label_rescale}{Scaling factor for chart labels (relative to axis
labels).}

\item{y_min}{Minimum limit of y axis.}

\item{rescale_y}{Scaling factor to extend y_max.}

\item{n_signif}{Number of significant figures in labels.}

\item{rotate_xlabel}{Logical.}

\item{bottom_label}{Logical.}

\item{ingroup_label}{Logical. Shows in-group percentage change.}

\item{n_x}{Number of x levels to show in chart.}
}
\description{
function for creating waterfall charts
}
\examples{
df = ez_data()
waterfall_plot(df, "year", "units", "fct")
waterfall_plot(df, "year", "units", "char")
waterfall_plot(df, "year", "units", "fct", n_x = 3)
waterfall_plot(df, "year", "units", "fct",
               label_rescale = 0.5,
               ingroup_label = TRUE,
               bottom_label = FALSE,
               n_x = 3,
               size = 20,
               y_min = 0,
               rotate_xlabel = TRUE)
}
