% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view}
\alias{view}
\title{Seamlessly manipulate any rectangular data file between an Excel window and R session.}
\usage{
view(x, ...)
}
\arguments{
\item{x}{An object of class data.frame, matrix, table or vector.}

\item{...}{Any additional arguments available for \link[writexl]{write_xlsx}.}
}
\value{
Data object opened in a preferable spreadsheet application window which will in turn be called on your R session again.
}
\description{
view function is deprecated to avoid any collision with \link[tibble]{view} function. Please use \link[ezpickr]{viewxl} instead.
}
\details{
view


See example below.
}
\examples{
if(interactive()) {
library(ezpickr)
data(airquality)
str(airquality)
## View your data object in your spreadsheet software:
view(airquality)
# Then, when necessary, you can modify the opened data in the spreadsheet and save it as a new data.

# You can pass a list object to the `view()` function like below:
l <- list(iris = iris, mtcars = mtcars, chickwts = chickwts, quakes = quakes)
view(l)
# Then, each list item will appear in your Excel window sheet by sheet.
}
}
\seealso{
\link[ezpickr]{viewxl}.
}
\author{
JooYoung Seo, \email{jooyoung@psu.edu}

Soyoung Choi, \email{sxc940@psu.edu}
}
\keyword{internal}
