% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.eyeris.R
\name{plot_binocular_correlation}
\alias{plot_binocular_correlation}
\title{Plot binocular correlation between left and right eye data}
\usage{
plot_binocular_correlation(
  eyeris,
  block = 1,
  variables = c("pupil", "x", "y"),
  main = "",
  col_palette = "viridis",
  sample_rate = NULL,
  verbose = TRUE
)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} derived from \code{\link[=load_asc]{load_asc()}}
with binocular data, or a list containing \code{left} and \code{right} eyeris objects
(from \code{binocular_mode = "both"})}

\item{block}{Block number to plot (default: 1)}

\item{variables}{Variables to plot correlations for. Defaults to
\code{c("pupil", "x", "y")} for pupil size, x-coordinates, and y-coordinates}

\item{main}{Title for the overall plot (default: "Binocular Correlation")}

\item{col_palette}{Color palette for the plots (default: "viridis")}

\item{sample_rate}{Sample rate in Hz (optional, for time-based sampling)}

\item{verbose}{Logical flag to indicate whether to print status messages
(default: TRUE)}
}
\value{
No return value; creates correlation plots
}
\description{
Creates correlation plots showing the relationship between left and right eye
measurements for pupil size, x-coordinates, and y-coordinates. This function
is useful for validating binocular data quality and assessing the correlation
between the two eyes.
}
\examples{
# For binocular data loaded with binocular_mode = "both"
binocular_data <- load_asc(eyelink_asc_binocular_demo_dataset(), binocular_mode = "both")
plot_binocular_correlation(binocular_data)

# For binocular data loaded with binocular_mode = "average"
# (correlation plot will show original left vs right before averaging)
avg_data <- load_asc(eyelink_asc_binocular_demo_dataset(), binocular_mode = "average")
plot_binocular_correlation(avg_data$raw_binocular_object)

}
