% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_sum.R
\name{sumnrow}
\alias{sumnrow}
\title{Sum every nth row of a matrix and name the resulting rows}
\usage{
sumnrow(df, N, row_names = NULL)
}
\arguments{
\item{df}{A matrix with named rows and columns.}

\item{N}{Integer, specifying the resulting number or rows.}

\item{row_names}{String vector of length \code{N}, with names to assign to the
resulting rows.}
}
\value{
A matrix with \code{N} rows, where each row is the sum of every \code{Nth} row
of the original matrix.
}
\description{
Groups a matrix by rows, summing every \code{Nth} row. Matrix should be multiple
of \code{N}.
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
sumnrow(wio$Y, wio$dims$N, paste0("WLD", "_",
        gsub("^D", "", wio$names$n_names)))
}
