% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_mult.R
\name{hmult}
\alias{hmult}
\title{Hadamard product of matrices}
\usage{
hmult(df1, df2)
}
\arguments{
\item{df1}{A block matrix with named rows and columns (country/sector)}

\item{df2}{A block matrix with named rows and columns (country/sector)}
}
\value{
Hadamard product of the two matrices.
}
\description{
Hadamard product, i.e., element by element product of matrix \code{df1}
and matrix \code{df2} (by blocks). Both matrices must be block matrices, and the
number and dimension of blocks in matrix \code{df1} and \code{df2} must be
compatible.
}
\details{
In a Hadamard product, matrices are multiplied block by block,
i.e., \code{block (s,r) \%*\% block(s,r)}.
}
