% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/extremogram2.R
\name{extremogram2}
\alias{extremogram2}
\title{Sample cross extremogram}
\usage{
extremogram2(a, quant1, quant2, maxlag, type, ploting = 1, cutoff = 1,
  start = 0, ...)
}
\arguments{
\item{a}{Bivariate time series (n by 2 matrix).}

\item{quant1}{Quantile of the first time series to indicate an extreme event (a number between 0 and 1).}

\item{quant2}{Quantile of the second time series to indicate an extreme event (a number between 0 and 1).}

\item{maxlag}{Number of lags to include in the extremogram (an integer).}

\item{type}{If type=1, the upper tail extremogram is estimated - P(Y>y,X>x).
If type=2, the lower tail extremogram is estimated - P(Y<y,X<x).
If type=3, the extremogram is estimated for a lower tail extreme value in the
first time series and an upper tail extreme value in the second time series -  P(Y>y,X<x).
If type=4, the extremogram is estimated for a lower tail extreme value in the
second time series and an upper tail extreme value in the first time series -  P(Y<y,X>x).}

\item{ploting}{An extremogram plot. If ploting = 1, a plot is created (default). If ploting = 0,
no plot is created.}

\item{cutoff}{The cutoff of the y-axis on the plot (a number between 0 and 1, default is 1).}

\item{start}{The lag that the extremogram plots starts at (an integer not greater than \code{maxlag}, default is 0).}

\item{...}{further arguments: plot and axis names.}
}
\value{
Cross extremogram values and a plot (if requested).
}
\description{
The function estimates the sample cross extremogram and creates an extremogram plot.
}
\examples{
# generate a GARCH(1,1) process
omega  = 1
alpha1 = 0.1
beta1  = 0.6
alpha2 = 0.11
beta2  = 0.78
n      = 1000
quant  = 0.95
type   = 1
maxlag = 70
df     = 3
G1     = extremogram:::garchsim(omega,alpha1,beta1,n,df)
G2     = extremogram:::garchsim(omega,alpha2,beta2,n,df)
data   = cbind(G1, G2)

extremogram2(data, quant, quant, maxlag, type, 1, 1, 0)
}
\references{
\enumerate{
            \item Davis, R. A., Mikosch, T., & Cribben, I. (2012). Towards estimating extremal
            serial dependence via the bootstrapped extremogram. Journal of Econometrics,170(1),
            142-152.
            \item Davis, R. A., Mikosch, T., & Cribben, I. (2011). Estimating extremal
            dependence in univariate and multivariate time series via the extremogram.arXiv
            preprint arXiv:1107.5592.}
}

