% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical-distribution.R
\name{Categorical}
\alias{Categorical}
\alias{dcat}
\alias{pcat}
\alias{qcat}
\alias{rcat}
\title{Categorical distribution}
\usage{
dcat(x, prob, log = FALSE)

pcat(q, prob, lower.tail = TRUE, log.p = FALSE)

qcat(p, prob, lower.tail = TRUE, log.p = FALSE, labels)

rcat(n, prob, labels)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{prob}{vector of length \eqn{k}, or \eqn{k}-column matrix
of probabilities. Probabilities need to sum up to 1.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{labels}{if provided, labeled \code{factor} vector is returned.
Number of labels needs to be the same as
number of categories (number of columns in prob).}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function, distribution function, quantile function and random generation
for the categorical distribution.
}
\examples{

# Generating 10 random draws from categorical distribution
# with k=3 categories occuring with equal probabilities
# parametrized using a vector

rcat(10, c(1/3, 1/3, 1/3))

# or with k=5 categories parametrized using a matrix of probabilities
# (generated from Dirichlet distribution)

p <- rdirichlet(10, c(1, 1, 1, 1, 1))
rcat(10, p)

x <- rcat(1e5, c(.2, .4, .3, .1))
plot(prop.table(table(x)), type = "h")
lines(0:5, dcat(0:5, c(.2, .4, .3, .1)), col = "red")

}
\keyword{distribution}

