% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expCreate.R
\name{expCreateFromTable}
\alias{expCreateFromTable}
\title{Create an exreport experiment from a tabular representation}
\usage{
expCreateFromTable(data, output, name, parameters = list(),
  respectOrder = FALSE)
}
\arguments{
\item{data}{Input tabular data satisfying the previous constraints.}

\item{output}{String indicating the name of the output that the table values
represent.}

\item{name}{A string which will identify the experiment in the report.}

\item{parameters}{A list of strings containing the names and values for the
static configuration
of the algorithm. The name of each element of the list will correspond with
the name of a parameter
and the element with the value asigned.}

\item{respectOrder}{A logical parameter which indicates if the order of the
elements of the method and problem columns must be respected by appearance or
ordered alphabeticaly. It affects to the look of data representations.}
}
\value{
A new exreport experiment object.
}
\description{
Create an exreport experiment object from a tabular representation.
The input data must be a table having methods as rows and problems as columns.
The values in such table correspond to a particular output.
The resulting experiment can be characterized with static parameters.
}
\examples{
# We generate a data frame where the methods are rows and the problems columns
# from the wekaExperiment problem. (This is only an example, normally you
# would prefer to load a proper experiment and process it.)

library(reshape2)
df <- dcast(wekaExperiment[wekaExperiment$featureSelection=="no",],
method ~ problem,
value.var="accuracy",
fun.aggregate = mean)

# We can create it and parametrice accordingly:
expCreateFromTable(df, output="accuracy", name="weka")

# Optionally we can set a fixed value for parameters, and ordered by appearance:
expCreateFromTable(df, output="accuracy", name="weka",
parameters=list(featureSelection = "no"), respectOrder=TRUE)
}
\seealso{
expCreate
}

