% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectors.R
\docType{data}
\name{vars}
\alias{vars}
\alias{vars_list}
\alias{indirect}
\alias{indirect_list}
\alias{\%to\%}
\alias{\%to_list\%}
\alias{..}
\alias{..f}
\alias{..p}
\title{Get variables/range of variables by name/by pattern.}
\format{An object of class \code{parameter} of length 1.}
\usage{
vars(...)

vars_list(...)

indirect(...)

indirect_list(...)

e1 \%to\% e2

e1 \%to_list\% e2

..

..f(...)

..p(...)
}
\arguments{
\item{...}{characters names of variables or criteria/logical functions}

\item{e1}{unquoted name of start variable (e. g. a_1)}

\item{e2}{unquoted name of start variable (e. g. a_5)}
}
\value{
data.frame/list with variables
}
\description{
\itemize{
\item{\code{vars}}{ returns data.frame with all variables by their names or
by criteria (see \link{criteria}). There is no non-standard evaluation in
this function by design so use quotes for names of your variables. This
function is intended to get variables by parameter/criteria. The only
exception with non-standard evaluation is \code{\%to\%}. You can use
\code{\%to\%} inside \code{vars} or independently.}
\item{\code{..p}}{ returns data.frame with all variables which names satisfy
supplied perl-style regular expression. Arguments for this function is quoted
characters. It is a shortcut for \code{vars(perl(pattern))}.}
\item{\code{..f}}{ returns data.frame with all variables which names contain
supplied pattern. Arguments for this function can be unquoted. It is a
shortcut for \code{vars(fixed(pattern))}.}
\item{\code{..[]}}{ returns data.frame with all variables by their names or 
by criteria (see \link{criteria}).  Names at the top-level can be unquoted 
(non-standard evaluation). For standard evaluation of parameters you can 
surround them by round brackets. You can assign to this expression. If there 
are several names inside square brackets then each element of list/data.frame
from right side will be assigned to appropriate name from left side. You can 
use \code{item1 \%to\% item2} notation to get/create sequence of variables. 
If there are no arguments inside square brackets than from each item of RHS 
will be created separate variable in the parent frame. In this case RHS
should be named list or data.frame. }
\item{\code{..$name}}{ sets/returns object which name is stored in the
variable \code{name}. It is convenient wrapper around 
\link[base]{get}/\link[base]{assign} functions.}
\item{\code{\%to\%}}{ returns range of variables between \code{e1} and 
\code{e2} (similar to SPSS 'to'). \link{modify}, \link{modify_if}, 
\link{calculate}, \link{keep}, \link{except} and \link{where} support 
\code{\%to\%}. Inside global environment \link[base]{with},
\link[base]{within} \code{\%to\%} will take range from names of variables
sorted in the alphabetic order.}
\item{\code{indirect}/\code{indirect_list}}{ are aliases for
\code{vars}/\code{vars_list}.}
}
Functions with word 'list' in name return lists of variables instead of 
dataframes.
}
\examples{
# In data.frame
dfs = data.frame(
    a = rep(1, 5),
    b_1 = rep(11, 5),
    b_2 = rep(12, 5),
    b_3 = rep(13, 5),
    b_4 = rep(14, 5),
    b_5 = rep(15, 5) 
)

# calculate sum of b_* variables
compute(dfs, {
    b_total = sum_row(b_1 \%to\% b_5)
})

# identical result
compute(dfs, {
    b_total = sum_row(..f(b_))
})

# In global environement
a = rep(10, 5)
a1 = rep(1, 5)
a2 = rep(2, 5)
a3 = rep(3, 5)
a4 = rep(4, 5)
a5 = rep(5, 5)

# identical results
a1 \%to\% a5
vars(perl("^a[0-9]$"))
..[perl("^a[0-9]$")]
..p("^a[0-9]$")

# sum each row
sum_row(a1 \%to\% a5)

# variable substitution
name1 = "a"
name2 = "new_var"

# in global environment
..$name1 # give as variable 'a'

..$name2 = ..$name1 * 2 # create variable 'new_var' which is equal to 'a' times 2
new_var

# inside data.frame
compute(dfs, {
     ..$name2 = ..$name1*2    
})

compute(dfs, {
     for(name1 in paste0("b_", 1:5)){
         name2 = paste0("new_", name1) 
         ..$name2 = ..$name1*2 
     }
     rm(name1, name2) # we don't need this variables as columns in 'dfs'
})

# square brackets notation - multi-assignment
name1 = paste0("b_", 1:5)
compute(dfs, {
          # round brackets about 'name1' is needed to avoid using it 'as is'
         ..[paste0("new_", name1)] = ..[(name1)]*2  
})

# the same result
# note the automatic creation of sequence of variables
compute(dfs, {
         ..[new_b_1 \%to\% new_b_5] = ..[b_1 \%to\% b_5]*2  
})

# assignment form of 'recode' on multiple variables
compute(dfs, {
         recode(..[b_1 \%to\% b_5]) = 13 \%thru\% hi ~ 20   
})

# empty brackets - unboxing of dichotomy.
compute(dfs, {
         ..[] =  as.dichotomy(b_1 \%to\% b_5, prefix = "v_")   
})
}
\seealso{
\link{keep}, \link{except}, \link{do_repeat}, \link{compute},
  \link{calculate}, \link{where}
}
\keyword{datasets}
