% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_labels.R
\name{split_labels}
\alias{split_labels}
\alias{split_columns}
\alias{split_table_to_df}
\title{Split character vector to matrix/split columns in data.frame}
\usage{
split_labels(x, remove_repeated = TRUE, split = "|", fixed = TRUE,
  perl = FALSE)

split_columns(data, columns = 1, remove_repeated = TRUE, split = "|",
  fixed = TRUE, perl = FALSE)

split_table_to_df(data, digits = getOption("expss.digits"),
  remove_repeated = TRUE, split = "|", fixed = TRUE, perl = FALSE)
}
\arguments{
\item{x}{character vector which will be split}

\item{remove_repeated}{logical. Should we remove repeated labels?}

\item{split}{character vector (or object which can be coerced to such)
containing regular expression(s) (unless \code{fixed = TRUE}) to use for
splitting.}

\item{fixed}{logical. If TRUE match split exactly, otherwise use regular
expressions. Has priority over \code{perl}.}

\item{perl}{logical. Should Perl-compatible regexps be used?}

\item{data}{data.frame vector which will be split}

\item{columns}{character/numeric/logical  columns in the data.frame
\code{data} which should be split}

\item{digits}{numeric. How many digits after decimal point should be left in
\code{split_table_to_df}?}
}
\value{
\code{split_labels} returns character matrix, \code{split_columns} returns
  data.frame with columns replaced by possibly multiple columns with split
  labels. \code{split_table_to_df} returns data.frame with character columns.
}
\description{
\code{split_labels}/\code{split_columns} are auxiliary functions for 
post-processing tables resulted from \link{cro}/\link{cro_fun} and etc. In
these tables all labels collapsed in the first column with "|" separator.
\code{split_columns} split first column into multiple columns with separator
(\code{split} argument). \code{split_table_to_df} split first column of table
and column names. Result of this operation is data.frame with character
columns.
}
\examples{
data(mtcars)

# apply labels
mtcars = apply_labels(mtcars,
    cyl = "Number of cylinders",
    vs = "Engine",
    vs = c("V-engine" = 0,
                    "Straight engine" = 1),
    am = "Transmission",
    am = c(automatic = 0,
                    manual=1),
    gear = "Number of forward gears",
    carb = "Number of carburetors"
)

# all row labels in the first column
tabl = mtcars \%>\% calculate(cro_cpct(list(cyl, gear, carb), list("#total", vs, am)))
split_labels(tabl[[1]])
split_labels(colnames(tabl))

# replace first column with new columns 
split_columns(tabl) # remove repeated

split_columns(tabl, remove_repeated = FALSE)

split_table_to_df(tabl)
}
\seealso{
\link[base]{strsplit}
}
