% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-pipe.R
\docType{methods}
\name{buildEnsemble}
\alias{buildEnsemble}
\alias{buildEnsemble,ExprsModel-method}
\alias{buildEnsemble,ExprsPipeline-method}
\title{Build Ensemble}
\usage{
buildEnsemble(object, ...)

\S4method{buildEnsemble}{ExprsModel}(object, ...)

\S4method{buildEnsemble}{ExprsPipeline}(object, colBy = 0, how = 0,
  gate = 0, top = 0)
}
\arguments{
\item{object}{An \code{\link{ExprsPipeline-class}} object.}

\item{...}{Additional \code{ExprsModel} objects to use in the ensemble.
Argument applies to the \code{\link{ExprsModel-class}} method only.}

\item{colBy}{A character vector or string. Specifies column(s) to use when
filtering by model performance. Listing multiple columns will result
in a filter based on the product all listed columns.}

\item{how}{A numeric scalar. Arguments between 0 and 1 will impose
a threshold or ceiling filter, respectively, based on the raw value of
\code{colBy}. Arguments between 1 and 100 will impose a filter based on
the percentile of \code{colBy}. The user may also provide "midrange",
"median", or "mean" as an argument for these filters.}

\item{gate}{A numeric scalar. Arguments between 0 and 1 will impose
a threshold or ceiling filter, respectively, based on the raw value of
\code{colBy}. Arguments between 1 and 100 will impose a filter based on
the percentile of \code{colBy}. The user may also provide "midrange",
"median", or "mean" as an argument for these filters.}

\item{top}{A numeric scalar. Determines the top N models based on
\code{colBy} to include after the threshold and ceiling filters.
In the case that the \code{@summary} slot contains the column "boot",
this selects the top N models for each unique bootstrap.}
}
\value{
An \code{\link{ExprsEnsemble-class}} object.
}
\description{
\code{buildEnsemble} builds an ensemble from \code{ExprsModel} or
 \code{ExprsPipeline} objects. See Details.
}
\details{
This function can combine any number of model objects into an ensemble.
 These models do not necessarily have to derive from the same \code{build}
 method. In this way, it works like \code{\link{conjoin}}.

This function can also build an ensemble from pipeline objects. It does
 this by calling \code{\link{pipeFilter}}, then joining the remaining models
 into an ensemble. As an adjunct to this method, consider first combining
 multiple pipeline objects with \code{\link{conjoin}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ExprsModel}: Method to build ensemble from \code{ExprsModel} objects.

\item \code{ExprsPipeline}: Method to build ensemble from \code{ExprsPipeline} objects.
}}

