% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.3-exprso.R
\name{exprso}
\alias{exprso}
\title{The \code{exprso} Package}
\usage{
exprso(x, y)
}
\arguments{
\item{x}{A matrix of feature data for all samples. Rows should
contain samples and columns should contain features.}

\item{y}{A vector of outcomes for all samples. If
\code{class(y) == "character"} or \code{class(y) == "factor"},
\code{exprso} prepares data for binary or multi-class classification.
Else, \code{exprso} prepares data for regression. If \code{y} is a
matrix, the program assumes the first column is the outcome.}
}
\value{
An \code{ExprsArray} object.
}
\description{
Welcome to the \code{exprso} package!

The \code{exprso} function imports data into the learning environment.

See \code{\link{mod}} to process the data.

See \code{\link{split}} to split off a test set.

See \code{\link{fs}} to select features.

See \code{\link{build}} to build models.

See \code{\link{pl}} to build models high-throughput.

See \code{\link{pipe}} to process pipelines.

See \code{\link{buildEnsemble}} to build ensembles.

See \code{\link{exprso-predict}} to deploy models.

See \code{\link{conjoin}} to merge objects.
}
\examples{
\dontrun{
library(exprso)
library(golubEsets)
data(Golub_Merge)
array <- arrayEset(Golub_Merge, colBy = "ALL.AML", include = list("ALL", "AML"))
array <- modFilter(array, 20, 16000, 500, 5) # pre-filter Golub ala Deb 2003
array <- modTransform(array) # lg transform
array <- modNormalize(array, c(1, 2)) # normalize gene and subject vectors
arrays <- splitSample(array, percent.include = 67)
array.train <- fsStats(arrays[[1]], top = 0, how = "t.test")
array.train <- fsPrcomp(array.train, top = 50)
mach <- buildSVM(array.train, top = 5, kernel = "linear", cost = 1)
}
}
