% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2.2-process.R
\docType{methods}
\name{modNormalize}
\alias{modNormalize}
\alias{modNormalize,ExprsArray-method}
\title{Normalize Data}
\usage{
modNormalize(object, MARGIN = c(1, 2), plotSkip = TRUE)

\S4method{modNormalize}{ExprsArray}(object, MARGIN = c(1, 2),
  plotSkip = TRUE)
}
\arguments{
\item{object}{Specifies the \code{ExprsArray} object to undergo pre-processing.}

\item{MARGIN}{A numeric vector. The margin by which to normalize.
Provide \code{MARGIN = 1} to normalize the feature vector.
Provide \code{MARGIN = 2} to normalize the subject vector.
Provide \code{MARGIN = c(1, 2)} to normalize by the subject vector
and then by the feature vector.}

\item{plotSkip}{A logical scalar. Toggles whether to produce side-by-side plots
of the before and after \code{ExprsArray} summary.}
}
\value{
A pre-processed \code{ExprsArray} object.
}
\description{
\code{modNormalize} normalizes feature data.
}
\details{
This method normalizes subject and/or feature vectors according to the
 formula \code{y = (x - mean(x)) / sd(x)}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ExprsArray}: Method to normalize an \code{ExprsArray} object.
}}
\seealso{
\code{\link{modFilter}}, \code{\link{modTransform}}, \code{\link{modNormalize}}
}

