% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph2vector.R
\name{graph2vector}
\alias{graph2vector}
\alias{graph2svg}
\alias{graph2pdf}
\alias{graph2eps}
\title{Save currently active R graph to vector format}
\usage{
graph2vector(
  x = NULL,
  file = "Rplot",
  fun = NULL,
  type = "SVG",
  aspectr = NULL,
  width = NULL,
  height = NULL,
  scaling = 100,
  font = ifelse(Sys.info()["sysname"] == "Windows", "Arial", "Helvetica")[[1]],
  bg = "white",
  colormodel = "rgb",
  cairo = TRUE,
  fallback_resolution = 600,
  ...
)

graph2svg(...)

graph2pdf(...)

graph2eps(...)
}
\arguments{
\item{x}{given \code{ggplot2} plot or \code{lattice} plot object to export; if
set to \code{NULL} the currently active R graph will be exported; not
supported for base R plots.}

\item{file}{name of output file. Any extension is ignored and added
according to the requested output type. If file already exists it is overwritten.}

\item{fun}{plot passed on as a function used to create it; useful especially
for base R plots.}

\item{type}{desired output type - \code{SVG}, \code{PDF} or \code{EPS} are currently supported.
\code{SVG} is the preferred format, and good for editing in Inkscape; \code{PDF} is good
for printing; \code{EPS} is sometimes requested by journals, though lower quality,
especially when semi-transparency is used, as this is rasterized to bitmap. 
\code{\link{graph2office}} is recommended for vector output to Microsoft Office.}

\item{aspectr}{desired width to height aspect ratio. If set to \code{NULL}, the
aspect ratio of the graphics device is used. Can also be combined with one
value for either the desired width or height of the graph.}

\item{width}{desired width in inches; can be combined with a desired
aspect ratio aspectr.}

\item{height}{desired height in inches; can be combined with a desired
aspect ratio aspectr.}

\item{scaling}{scale width & height by a certain percentage.}

\item{font}{desired font to use for labels; defaults to \code{"Arial"} on Windows
systems and to \code{"Helvetica"} on other systems. Fonts are embedded by default in \code{EPS} output.}

\item{bg}{desired background colour, e.g. \code{"white"} or \code{"transparent"}.}

\item{colormodel}{desired colormodel in \code{pdf} or \code{eps} output when \code{cairo=FALSE};
currently allowed values are \code{"rgb"} (default), \code{"cmyk"}, \code{"srgb"}, \code{"srgb+gray"}, \code{"rgb-nogray"}, 
and \code{"gray"} (or \code{"grey"}).}

\item{cairo}{logical indicating whether or not to use the \code{cairo} graphics
device for output to \code{PDF} or \code{EPS}, defaults to \code{TRUE}, thereby allowing for
simulated semi-transparency in \code{EPS} output, by rasterizing semi-transparent
sections, and automated font embedding.}

\item{fallback_resolution}{resolution in dpi to use to rasterize non-supported
vector graphics (e.g. semi-transparent vector elements in \code{EPS}) output).}

\item{\dots}{any other options are passed on to \code{\link{svg}}, \code{\link{cairo_pdf}}, \code{\link{cairo_ps}}, \code{\link{pdf}} or
postscript.}
}
\value{
No return value
}
\description{
Save the currently active R graph or a graph passed as an object or function 
to vector format with sensible defaults
}
\section{Functions}{
\itemize{
\item \code{graph2svg()}: Save currently active R graph to SVG format

\item \code{graph2pdf()}: Save currently active R graph to PDF format

\item \code{graph2eps()}: Save currently active R graph to EPS format

}}
\examples{
# Create a file name
filen <- tempfile(pattern = "ggplot") # or 
# filen <- paste("YOUR_DIR/ggplot")

# Generate graphical output
library(ggplot2)
library(datasets)
x=qplot(Sepal.Length, Petal.Length, data = iris, 
        color = Species, size = Petal.Width, alpha = I(0.7))
plot.fun <- function(){
  print(qplot(Sepal.Length, Petal.Length, data = iris, 
              color = Species, size = Petal.Width, alpha = 0.7))
}

# There are 3 ways to use graph2vector():
### 1. Pass the plot as an object
graph2svg(x=x, file=filen, aspectr=2, font = "Times New Roman", 
          height = 5, bg = "white")
graph2pdf(x=x, file=filen, aspectr=2, font = "Arial",   
          height = 5, bg = "transparent")
graph2eps(x=x, file=filen, aspectr=2, font = "Arial",   
          height = 5, bg = "transparent")
### 2. Get the plot from current screen device
if (interactive()) { # Because the example uses screen devices 
  x
  graph2svg(file=filen, aspectr=2, font = "Arial",  
            height = 5, bg = "transparent")
  graph2pdf(file=filen, aspectr=2, font = "Times New Roman",   
            height = 5, bg = "white")
  graph2eps(file=filen, aspectr=2, font = "Times New Roman",   
            height = 5, bg = "white")
}
### 3. Pass the plot as a function
if (interactive()) { # Because the example uses screen devices 
  graph2svg(file=filen, fun = plot.fun, aspectr=2, font = "Arial",  
            height = 5, bg = "transparent")
  graph2pdf(file=filen, fun=plot.fun, aspectr=2, font = "Arial",   
            height = 5, bg = "transparent")
  graph2eps(file=filen, fun=plot.fun, aspectr=2, font = "Arial",   
            height = 5, bg = "transparent")
} 

}
\seealso{
\code{\link{graph2office}}, \code{\link{graph2bitmap}}, \code{\link{graph2png}}, \code{\link{graph2tif}}, \code{\link{graph2jpg}}
}
\author{
Tom Wenseleers
}
