% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{print.expirest_osle}
\alias{print.expirest_osle}
\title{Print a summary of the shelf life estimation (osle)}
\usage{
\method{print}{expirest_osle}(x, ...)
}
\arguments{
\item{x}{An object of class \sQuote{\code{expirest_osle}} returned by
the \code{\link{expirest_osle}()} function.}

\item{...}{Further arguments passed to or from other methods or arguments
that can be passed down to the \code{\link[base]{formatC}()} function.}
}
\value{
The \sQuote{\code{expirest_osle}} object passed to the \code{x}
parameter is returned invisibly.
}
\description{
This is a method for the function \code{print()} for objects of class
\sQuote{\code{expirest_osle}}.
}
\details{
The function \code{\link{expirest_osle}()} estimates the shelf
life, or retest period, following the ICH Q1E guideline. By default, batch
poolability is checked as recommended by the guideline at a significance
level of 0.25. Other levels can be used, although not recommended, by
changing the default of the \code{alpha_pool} parameter. Three possible
models may be appropriate, i.e.
\itemize{
 \item a \emph{common intercept / common slope} model (cics),
 \item a \emph{different intercept / common slope} model (dics) or
 \item a \emph{different intercept / different slope} model (dids).
}

The worst case intercept is the intercept of the batch whose confidence
limit is the first crossing the acceptance limit. As in case of the
\code{cics} model type all batches have a common intercept and a common
confidence interval, all batches can be regarded as equally worst case. In
case of the \code{dids} model type, shelf life estimation is done using the
models obtained from fitting the data of each batch individually.
}
\examples{
# Potency stability data (in \% of label claim (LC)) of five batches of a drug
# product obtained over a 24 months period:
str(exp1)

# 'data.frame':	53 obs. of  3 variables:
# $ Batch  : Factor w/ 6 levels "b2","b3","b4",..: 1 1 1 1 1 1 1 1 1 1 ...
# $ Month  : num  0 1 3 3 6 6 12 12 24 24 ...
# $ Potency: num  101 101.3 99.8 99.2 99.5 ...

# Fit models of different type
res1 <-
  expirest_osle(data = exp1[exp1$Batch \%in\% c("b2", "b5", "b7"), ],
                response_vbl = "Potency", time_vbl = "Month",
                batch_vbl = "Batch", sl = 95, sl_sf = 3, srch_range = c(0, 500))
res2 <-
  expirest_osle(data = exp1[exp1$Batch \%in\% c("b3", "b4", "b5"), ],
                response_vbl = "Potency", time_vbl = "Month",
                batch_vbl = "Batch", sl = 95, sl_sf = 3, srch_range = c(0, 500))
res3 <-
  expirest_osle(data = exp1[exp1$Batch \%in\% c("b4", "b5", "b8"), ],
                response_vbl = "Potency", time_vbl = "Month",
                batch_vbl = "Batch", sl = 95, sl_sf = 3, srch_range = c(0, 500))

res1
# Expected output of print(res1)
# Summary of shelf life estimation following the ICH Q1E guideline
#
# The best model accepted at a significance level of 0.25 has
# Common intercepts and Common slopes (acronym: cics).
#
# Worst case intercept: 100.5669
# Worst case batch: NA
#
# Estimated shelf life for cics model:  26.2241

res2
# Expected output of print(res2)
# Summary of shelf life estimation following the ICH Q1E guideline
#
# The best model accepted at a significance level of 0.25 has
# Different intercepts and Common slopes (acronym: dics).
#
# Worst case intercept:   100.82
# Worst case batch: b5
#
# Estimated shelf life for dics model: 23.60194

res3
# Expected output of print(res3)
# Summary of shelf life estimation following the ICH Q1E guideline
#
# The best model accepted at a significance level of 0.25 has
# Different intercepts and Different slopes (acronym: dids).
#
# Worst case intercept: 101.2594
# Worst case batch: b8
#
# Estimated shelf life for dids model: 15.96453
}
\seealso{
\code{\link{expirest_osle}}, \code{\link{expirest_wisle}},
\code{\link[base]{formatC}}, \code{\link[utils]{methods}}.
}
