// Generated by rstantools.  Do not edit by hand.

/*
    expertsurv is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    expertsurv is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with expertsurv.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_RP_expert_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_RP_expert");
    reader.add_event(171, 169, "end", "model_RP_expert");
    return reader;
}
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type
rps_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& t,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& d,
             const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& gamma,
             const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& B,
             const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& DB,
             const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& linpred,
             const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a0, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 11;
        validate_non_negative_index("eta", "num_elements(t)", num_elements(t));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta(num_elements(t));
        stan::math::initialize(eta, DUMMY_VAR__);
        stan::math::fill(eta, DUMMY_VAR__);
        current_statement_begin__ = 12;
        validate_non_negative_index("eta_prime", "num_elements(t)", num_elements(t));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_prime(num_elements(t));
        stan::math::initialize(eta_prime, DUMMY_VAR__);
        stan::math::fill(eta_prime, DUMMY_VAR__);
        current_statement_begin__ = 13;
        validate_non_negative_index("log_lik", "num_elements(t)", num_elements(t));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(num_elements(t));
        stan::math::initialize(log_lik, DUMMY_VAR__);
        stan::math::fill(log_lik, DUMMY_VAR__);
        current_statement_begin__ = 14;
        local_scalar_t__ lprob(DUMMY_VAR__);
        (void) lprob;  // dummy to suppress unused var warning
        stan::math::initialize(lprob, DUMMY_VAR__);
        stan::math::fill(lprob, DUMMY_VAR__);
        current_statement_begin__ = 16;
        stan::math::assign(eta, add(multiply(B, gamma), linpred));
        current_statement_begin__ = 17;
        stan::math::assign(eta_prime, multiply(DB, gamma));
        current_statement_begin__ = 18;
        stan::math::assign(log_lik, subtract(elt_multiply(d, add(add(minus(stan::math::log(t)), stan::math::log(eta_prime)), eta)), stan::math::exp(eta)));
        current_statement_begin__ = 19;
        stan::math::assign(lprob, dot_product(log_lik, a0));
        current_statement_begin__ = 20;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lprob);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type
rps_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& t,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& d,
             const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& gamma,
             const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& B,
             const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& DB,
             const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& linpred,
             const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a0, std::ostream* pstream__) {
    return rps_lpdf<false>(t,d,gamma,B,DB,linpred,a0, pstream__);
}
struct rps_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& t,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& d,
             const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& gamma,
             const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& B,
             const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& DB,
             const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& linpred,
             const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& a0, std::ostream* pstream__) const {
        return rps_lpdf(t, d, gamma, B, DB, linpred, a0, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
Sind(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& gamma,
         const Eigen::Matrix<T1__, 1, Eigen::Dynamic>& B,
         const T2__& linpred, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 31;
        local_scalar_t__ eta(DUMMY_VAR__);
        (void) eta;  // dummy to suppress unused var warning
        stan::math::initialize(eta, DUMMY_VAR__);
        stan::math::fill(eta, DUMMY_VAR__);
        current_statement_begin__ = 32;
        local_scalar_t__ Sind_rtn(DUMMY_VAR__);
        (void) Sind_rtn;  // dummy to suppress unused var warning
        stan::math::initialize(Sind_rtn, DUMMY_VAR__);
        stan::math::fill(Sind_rtn, DUMMY_VAR__);
        current_statement_begin__ = 34;
        stan::math::assign(eta, (multiply(B, gamma) + linpred));
        current_statement_begin__ = 35;
        stan::math::assign(Sind_rtn, stan::math::exp(-(stan::math::exp(eta))));
        current_statement_begin__ = 36;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Sind_rtn);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct Sind_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& gamma,
         const Eigen::Matrix<T1__, 1, Eigen::Dynamic>& B,
         const T2__& linpred, std::ostream* pstream__) const {
        return Sind(gamma, B, linpred, pstream__);
    }
};
template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
log_density_dist(const std::vector<std::vector<T0__> >& params,
                     const T1__& x,
                     const int& num_expert,
                     const int& pool_type, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 45;
        validate_non_negative_index("dens", "num_expert", num_expert);
        std::vector<local_scalar_t__  > dens(num_expert, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(dens, DUMMY_VAR__);
        stan::math::fill(dens, DUMMY_VAR__);
        current_statement_begin__ = 47;
        for (int i = 1; i <= num_expert; ++i) {
            current_statement_begin__ = 48;
            if (as_bool(logical_eq(get_base1(get_base1(params, i, "params", 1), 1, "params", 2), 1))) {
                current_statement_begin__ = 49;
                if (as_bool(logical_eq(pool_type, 1))) {
                    current_statement_begin__ = 50;
                    stan::model::assign(dens, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::math::exp(normal_log(x, get_base1(get_base1(params, i, "params", 1), 3, "params", 2), get_base1(get_base1(params, i, "params", 1), 4, "params", 2))) * get_base1(get_base1(params, i, "params", 1), 2, "params", 2)), 
                                "assigning variable dens");
                } else {
                    current_statement_begin__ = 52;
                    stan::model::assign(dens, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                pow(stan::math::exp(normal_log(x, get_base1(get_base1(params, i, "params", 1), 3, "params", 2), get_base1(get_base1(params, i, "params", 1), 4, "params", 2))), get_base1(get_base1(params, i, "params", 1), 2, "params", 2)), 
                                "assigning variable dens");
                }
            } else if (as_bool(logical_eq(get_base1(get_base1(params, i, "params", 1), 1, "params", 2), 2))) {
                current_statement_begin__ = 56;
                if (as_bool(logical_eq(pool_type, 1))) {
                    current_statement_begin__ = 57;
                    stan::model::assign(dens, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::math::exp(student_t_log(x, get_base1(get_base1(params, i, "params", 1), 5, "params", 2), get_base1(get_base1(params, i, "params", 1), 3, "params", 2), get_base1(get_base1(params, i, "params", 1), 4, "params", 2))) * get_base1(get_base1(params, i, "params", 1), 2, "params", 2)), 
                                "assigning variable dens");
                } else {
                    current_statement_begin__ = 59;
                    stan::model::assign(dens, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                pow(stan::math::exp(student_t_log(x, get_base1(get_base1(params, i, "params", 1), 5, "params", 2), get_base1(get_base1(params, i, "params", 1), 3, "params", 2), get_base1(get_base1(params, i, "params", 1), 4, "params", 2))), get_base1(get_base1(params, i, "params", 1), 2, "params", 2)), 
                                "assigning variable dens");
                }
            } else if (as_bool(logical_eq(get_base1(get_base1(params, i, "params", 1), 1, "params", 2), 3))) {
                current_statement_begin__ = 63;
                if (as_bool(logical_eq(pool_type, 1))) {
                    current_statement_begin__ = 64;
                    stan::model::assign(dens, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::math::exp(gamma_log(x, get_base1(get_base1(params, i, "params", 1), 3, "params", 2), get_base1(get_base1(params, i, "params", 1), 4, "params", 2))) * get_base1(get_base1(params, i, "params", 1), 2, "params", 2)), 
                                "assigning variable dens");
                } else {
                    current_statement_begin__ = 66;
                    stan::model::assign(dens, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                pow(stan::math::exp(gamma_log(x, get_base1(get_base1(params, i, "params", 1), 3, "params", 2), get_base1(get_base1(params, i, "params", 1), 4, "params", 2))), get_base1(get_base1(params, i, "params", 1), 2, "params", 2)), 
                                "assigning variable dens");
                }
            } else if (as_bool(logical_eq(get_base1(get_base1(params, i, "params", 1), 1, "params", 2), 4))) {
                current_statement_begin__ = 71;
                if (as_bool(logical_eq(pool_type, 1))) {
                    current_statement_begin__ = 72;
                    stan::model::assign(dens, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::math::exp(lognormal_log(x, get_base1(get_base1(params, i, "params", 1), 3, "params", 2), get_base1(get_base1(params, i, "params", 1), 4, "params", 2))) * get_base1(get_base1(params, i, "params", 1), 2, "params", 2)), 
                                "assigning variable dens");
                } else {
                    current_statement_begin__ = 74;
                    stan::model::assign(dens, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                pow(stan::math::exp(lognormal_log(x, get_base1(get_base1(params, i, "params", 1), 3, "params", 2), get_base1(get_base1(params, i, "params", 1), 4, "params", 2))), get_base1(get_base1(params, i, "params", 1), 2, "params", 2)), 
                                "assigning variable dens");
                }
            } else if (as_bool(logical_eq(get_base1(get_base1(params, i, "params", 1), 1, "params", 2), 5))) {
                current_statement_begin__ = 78;
                if (as_bool(logical_eq(pool_type, 1))) {
                    current_statement_begin__ = 79;
                    stan::model::assign(dens, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::math::exp(beta_log(x, get_base1(get_base1(params, i, "params", 1), 3, "params", 2), get_base1(get_base1(params, i, "params", 1), 4, "params", 2))) * get_base1(get_base1(params, i, "params", 1), 2, "params", 2)), 
                                "assigning variable dens");
                } else {
                    current_statement_begin__ = 81;
                    stan::model::assign(dens, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                pow(stan::math::exp(beta_log(x, get_base1(get_base1(params, i, "params", 1), 3, "params", 2), get_base1(get_base1(params, i, "params", 1), 4, "params", 2))), get_base1(get_base1(params, i, "params", 1), 2, "params", 2)), 
                                "assigning variable dens");
                }
            }
        }
        current_statement_begin__ = 90;
        if (as_bool(logical_eq(pool_type, 1))) {
            current_statement_begin__ = 91;
            return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::log(sum(dens)));
        } else {
            current_statement_begin__ = 93;
            return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::log(prod(dens)));
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct log_density_dist_functor__ {
    template <typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const std::vector<std::vector<T0__> >& params,
                     const T1__& x,
                     const int& num_expert,
                     const int& pool_type, std::ostream* pstream__) const {
        return log_density_dist(params, x, num_expert, pool_type, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_RP_expert
  : public stan::model::model_base_crtp<model_RP_expert> {
private:
        int n;
        int M;
        int H;
        vector_d t;
        vector_d d;
        matrix_d X;
        matrix_d B;
        matrix_d DB;
        vector_d mu_beta;
        vector_d sigma_beta;
        vector_d mu_gamma;
        vector_d sigma_gamma;
        int n_time_expert;
        int St_indic;
        int id_St;
        int id_trt;
        int id_comp;
        std::vector<int> n_experts;
        int pool_type;
        std::vector<std::vector<std::vector<double> > > param_expert;
        vector_d time_expert;
        matrix_d B_expert;
        vector_d a0;
public:
    model_RP_expert(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_RP_expert(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_RP_expert_namespace::model_RP_expert";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 101;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 1);
            current_statement_begin__ = 102;
            context__.validate_dims("data initialization", "M", "int", context__.to_vec());
            M = int(0);
            vals_i__ = context__.vals_i("M");
            pos__ = 0;
            M = vals_i__[pos__++];
            check_greater_or_equal(function__, "M", M, 0);
            current_statement_begin__ = 103;
            context__.validate_dims("data initialization", "H", "int", context__.to_vec());
            H = int(0);
            vals_i__ = context__.vals_i("H");
            pos__ = 0;
            H = vals_i__[pos__++];
            check_greater_or_equal(function__, "H", H, 1);
            current_statement_begin__ = 104;
            validate_non_negative_index("t", "n", n);
            context__.validate_dims("data initialization", "t", "vector_d", context__.to_vec(n));
            t = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < t_j_1_max__; ++j_1__) {
                t(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "t", t, 0);
            current_statement_begin__ = 105;
            validate_non_negative_index("d", "n", n);
            context__.validate_dims("data initialization", "d", "vector_d", context__.to_vec(n));
            d = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("d");
            pos__ = 0;
            size_t d_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
                d(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "d", d, 0);
            check_less_or_equal(function__, "d", d, 1);
            current_statement_begin__ = 106;
            validate_non_negative_index("X", "n", n);
            validate_non_negative_index("X", "H", H);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(n,H));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, H);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = H;
            size_t X_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 107;
            validate_non_negative_index("B", "n", n);
            validate_non_negative_index("B", "(M + 2)", (M + 2));
            context__.validate_dims("data initialization", "B", "matrix_d", context__.to_vec(n,(M + 2)));
            B = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, (M + 2));
            vals_r__ = context__.vals_r("B");
            pos__ = 0;
            size_t B_j_2_max__ = (M + 2);
            size_t B_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < B_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
                    B(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 108;
            validate_non_negative_index("DB", "n", n);
            validate_non_negative_index("DB", "(M + 2)", (M + 2));
            context__.validate_dims("data initialization", "DB", "matrix_d", context__.to_vec(n,(M + 2)));
            DB = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, (M + 2));
            vals_r__ = context__.vals_r("DB");
            pos__ = 0;
            size_t DB_j_2_max__ = (M + 2);
            size_t DB_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < DB_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < DB_j_1_max__; ++j_1__) {
                    DB(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 109;
            validate_non_negative_index("mu_beta", "H", H);
            context__.validate_dims("data initialization", "mu_beta", "vector_d", context__.to_vec(H));
            mu_beta = Eigen::Matrix<double, Eigen::Dynamic, 1>(H);
            vals_r__ = context__.vals_r("mu_beta");
            pos__ = 0;
            size_t mu_beta_j_1_max__ = H;
            for (size_t j_1__ = 0; j_1__ < mu_beta_j_1_max__; ++j_1__) {
                mu_beta(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 110;
            validate_non_negative_index("sigma_beta", "H", H);
            context__.validate_dims("data initialization", "sigma_beta", "vector_d", context__.to_vec(H));
            sigma_beta = Eigen::Matrix<double, Eigen::Dynamic, 1>(H);
            vals_r__ = context__.vals_r("sigma_beta");
            pos__ = 0;
            size_t sigma_beta_j_1_max__ = H;
            for (size_t j_1__ = 0; j_1__ < sigma_beta_j_1_max__; ++j_1__) {
                sigma_beta(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "sigma_beta", sigma_beta, 0);
            current_statement_begin__ = 111;
            validate_non_negative_index("mu_gamma", "(M + 2)", (M + 2));
            context__.validate_dims("data initialization", "mu_gamma", "vector_d", context__.to_vec((M + 2)));
            mu_gamma = Eigen::Matrix<double, Eigen::Dynamic, 1>((M + 2));
            vals_r__ = context__.vals_r("mu_gamma");
            pos__ = 0;
            size_t mu_gamma_j_1_max__ = (M + 2);
            for (size_t j_1__ = 0; j_1__ < mu_gamma_j_1_max__; ++j_1__) {
                mu_gamma(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 112;
            validate_non_negative_index("sigma_gamma", "(M + 2)", (M + 2));
            context__.validate_dims("data initialization", "sigma_gamma", "vector_d", context__.to_vec((M + 2)));
            sigma_gamma = Eigen::Matrix<double, Eigen::Dynamic, 1>((M + 2));
            vals_r__ = context__.vals_r("sigma_gamma");
            pos__ = 0;
            size_t sigma_gamma_j_1_max__ = (M + 2);
            for (size_t j_1__ = 0; j_1__ < sigma_gamma_j_1_max__; ++j_1__) {
                sigma_gamma(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "sigma_gamma", sigma_gamma, 0);
            current_statement_begin__ = 114;
            context__.validate_dims("data initialization", "n_time_expert", "int", context__.to_vec());
            n_time_expert = int(0);
            vals_i__ = context__.vals_i("n_time_expert");
            pos__ = 0;
            n_time_expert = vals_i__[pos__++];
            current_statement_begin__ = 115;
            context__.validate_dims("data initialization", "St_indic", "int", context__.to_vec());
            St_indic = int(0);
            vals_i__ = context__.vals_i("St_indic");
            pos__ = 0;
            St_indic = vals_i__[pos__++];
            check_greater_or_equal(function__, "St_indic", St_indic, 0);
            check_less_or_equal(function__, "St_indic", St_indic, 1);
            current_statement_begin__ = 117;
            context__.validate_dims("data initialization", "id_St", "int", context__.to_vec());
            id_St = int(0);
            vals_i__ = context__.vals_i("id_St");
            pos__ = 0;
            id_St = vals_i__[pos__++];
            current_statement_begin__ = 118;
            context__.validate_dims("data initialization", "id_trt", "int", context__.to_vec());
            id_trt = int(0);
            vals_i__ = context__.vals_i("id_trt");
            pos__ = 0;
            id_trt = vals_i__[pos__++];
            current_statement_begin__ = 119;
            context__.validate_dims("data initialization", "id_comp", "int", context__.to_vec());
            id_comp = int(0);
            vals_i__ = context__.vals_i("id_comp");
            pos__ = 0;
            id_comp = vals_i__[pos__++];
            current_statement_begin__ = 121;
            validate_non_negative_index("n_experts", "n_time_expert", n_time_expert);
            context__.validate_dims("data initialization", "n_experts", "int", context__.to_vec(n_time_expert));
            n_experts = std::vector<int>(n_time_expert, int(0));
            vals_i__ = context__.vals_i("n_experts");
            pos__ = 0;
            size_t n_experts_k_0_max__ = n_time_expert;
            for (size_t k_0__ = 0; k_0__ < n_experts_k_0_max__; ++k_0__) {
                n_experts[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 122;
            context__.validate_dims("data initialization", "pool_type", "int", context__.to_vec());
            pool_type = int(0);
            vals_i__ = context__.vals_i("pool_type");
            pos__ = 0;
            pool_type = vals_i__[pos__++];
            current_statement_begin__ = 124;
            validate_non_negative_index("param_expert", "max(n_experts)", max(n_experts));
            validate_non_negative_index("param_expert", "5", 5);
            validate_non_negative_index("param_expert", "n_time_expert", n_time_expert);
            context__.validate_dims("data initialization", "param_expert", "double", context__.to_vec(max(n_experts),5,n_time_expert));
            param_expert = std::vector<std::vector<std::vector<double> > >(max(n_experts), std::vector<std::vector<double> >(5, std::vector<double>(n_time_expert, double(0))));
            vals_r__ = context__.vals_r("param_expert");
            pos__ = 0;
            size_t param_expert_k_0_max__ = max(n_experts);
            size_t param_expert_k_1_max__ = 5;
            size_t param_expert_k_2_max__ = n_time_expert;
            for (size_t k_2__ = 0; k_2__ < param_expert_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < param_expert_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < param_expert_k_0_max__; ++k_0__) {
                        param_expert[k_0__][k_1__][k_2__] = vals_r__[pos__++];
                    }
                }
            }
            current_statement_begin__ = 125;
            validate_non_negative_index("time_expert", "(St_indic ? n_time_expert : 0 )", (St_indic ? n_time_expert : 0 ));
            context__.validate_dims("data initialization", "time_expert", "vector_d", context__.to_vec((St_indic ? n_time_expert : 0 )));
            time_expert = Eigen::Matrix<double, Eigen::Dynamic, 1>((St_indic ? n_time_expert : 0 ));
            vals_r__ = context__.vals_r("time_expert");
            pos__ = 0;
            size_t time_expert_j_1_max__ = (St_indic ? n_time_expert : 0 );
            for (size_t j_1__ = 0; j_1__ < time_expert_j_1_max__; ++j_1__) {
                time_expert(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 127;
            validate_non_negative_index("B_expert", "n_time_expert", n_time_expert);
            validate_non_negative_index("B_expert", "(M + 2)", (M + 2));
            context__.validate_dims("data initialization", "B_expert", "matrix_d", context__.to_vec(n_time_expert,(M + 2)));
            B_expert = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_time_expert, (M + 2));
            vals_r__ = context__.vals_r("B_expert");
            pos__ = 0;
            size_t B_expert_j_2_max__ = (M + 2);
            size_t B_expert_j_1_max__ = n_time_expert;
            for (size_t j_2__ = 0; j_2__ < B_expert_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < B_expert_j_1_max__; ++j_1__) {
                    B_expert(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 128;
            validate_non_negative_index("a0", "n", n);
            context__.validate_dims("data initialization", "a0", "vector_d", context__.to_vec(n));
            a0 = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("a0");
            pos__ = 0;
            size_t a0_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < a0_j_1_max__; ++j_1__) {
                a0(j_1__) = vals_r__[pos__++];
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 133;
            validate_non_negative_index("gamma", "(M + 2)", (M + 2));
            num_params_r__ += (M + 2);
            current_statement_begin__ = 134;
            validate_non_negative_index("beta", "H", H);
            num_params_r__ += H;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_RP_expert() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 133;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        validate_non_negative_index("gamma", "(M + 2)", (M + 2));
        context__.validate_dims("parameter initialization", "gamma", "vector_d", context__.to_vec((M + 2)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma((M + 2));
        size_t gamma_j_1_max__ = (M + 2);
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            gamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 134;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "H", H);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(H));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(H);
        size_t beta_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 133;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.vector_constrain((M + 2), lp__);
            else
                gamma = in__.vector_constrain((M + 2));
            current_statement_begin__ = 134;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(H, lp__);
            else
                beta = in__.vector_constrain(H);
            // transformed parameters
            current_statement_begin__ = 139;
            validate_non_negative_index("linpred", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> linpred(n);
            stan::math::initialize(linpred, DUMMY_VAR__);
            stan::math::fill(linpred, DUMMY_VAR__);
            current_statement_begin__ = 140;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 141;
            validate_non_negative_index("St_expert", "n_time_expert", n_time_expert);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> St_expert(n_time_expert);
            stan::math::initialize(St_expert, DUMMY_VAR__);
            stan::math::fill(St_expert, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 143;
            stan::math::assign(linpred, multiply(X, beta));
            current_statement_begin__ = 144;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 145;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            get_base1(linpred, i, "linpred", 1), 
                            "assigning variable mu");
            }
            current_statement_begin__ = 147;
            for (int i = 1; i <= n_time_expert; ++i) {
                current_statement_begin__ = 148;
                stan::model::assign(St_expert, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Sind(gamma, row(B_expert, i), get_base1(mu, id_St, "mu", 1), pstream__), 
                            "assigning variable St_expert");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 139;
            size_t linpred_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < linpred_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(linpred(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: linpred" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable linpred: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 140;
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 141;
            size_t St_expert_j_1_max__ = n_time_expert;
            for (size_t j_1__ = 0; j_1__ < St_expert_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(St_expert(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: St_expert" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable St_expert: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 156;
            lp_accum__.add(normal_log<propto__>(gamma, mu_gamma, sigma_gamma));
            current_statement_begin__ = 157;
            lp_accum__.add(normal_log<propto__>(beta, mu_beta, sigma_beta));
            current_statement_begin__ = 160;
            lp_accum__.add(rps_lpdf<propto__>(t, d, gamma, B, DB, multiply(X, beta), a0, pstream__));
            current_statement_begin__ = 162;
            for (int i = 1; i <= n_time_expert; ++i) {
                current_statement_begin__ = 164;
                lp_accum__.add(log_density_dist(stan::model::rvalue(param_expert, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()))), "param_expert"), get_base1(St_expert, i, "St_expert", 1), get_base1(n_experts, i, "n_experts", 1), pool_type, pstream__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("gamma");
        names__.push_back("beta");
        names__.push_back("linpred");
        names__.push_back("mu");
        names__.push_back("St_expert");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((M + 2));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(H);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_time_expert);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_RP_expert_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma = in__.vector_constrain((M + 2));
        size_t gamma_j_1_max__ = (M + 2);
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            vars__.push_back(gamma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(H);
        size_t beta_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 139;
            validate_non_negative_index("linpred", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> linpred(n);
            stan::math::initialize(linpred, DUMMY_VAR__);
            stan::math::fill(linpred, DUMMY_VAR__);
            current_statement_begin__ = 140;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 141;
            validate_non_negative_index("St_expert", "n_time_expert", n_time_expert);
            Eigen::Matrix<double, Eigen::Dynamic, 1> St_expert(n_time_expert);
            stan::math::initialize(St_expert, DUMMY_VAR__);
            stan::math::fill(St_expert, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 143;
            stan::math::assign(linpred, multiply(X, beta));
            current_statement_begin__ = 144;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 145;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            get_base1(linpred, i, "linpred", 1), 
                            "assigning variable mu");
            }
            current_statement_begin__ = 147;
            for (int i = 1; i <= n_time_expert; ++i) {
                current_statement_begin__ = 148;
                stan::model::assign(St_expert, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Sind(gamma, row(B_expert, i), get_base1(mu, id_St, "mu", 1), pstream__), 
                            "assigning variable St_expert");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t linpred_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < linpred_j_1_max__; ++j_1__) {
                    vars__.push_back(linpred(j_1__));
                }
                size_t mu_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t St_expert_j_1_max__ = n_time_expert;
                for (size_t j_1__ = 0; j_1__ < St_expert_j_1_max__; ++j_1__) {
                    vars__.push_back(St_expert(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_RP_expert";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t gamma_j_1_max__ = (M + 2);
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t linpred_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < linpred_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "linpred" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t St_expert_j_1_max__ = n_time_expert;
            for (size_t j_1__ = 0; j_1__ < St_expert_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "St_expert" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t gamma_j_1_max__ = (M + 2);
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t linpred_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < linpred_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "linpred" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t St_expert_j_1_max__ = n_time_expert;
            for (size_t j_1__ = 0; j_1__ < St_expert_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "St_expert" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_RP_expert_namespace::model_RP_expert stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
