% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUPEC.R
\name{AUPEC}
\alias{AUPEC}
\title{Estimation of the unnormalized Area Under Prescription Evaluation Curve (AUPEC) in Completely Randomized Experiments}
\usage{
AUPEC(T, tau, Y)
}
\arguments{
\item{T}{The unit-level binary treatment receipt variable.}

\item{tau}{The unit-level continuous score for treatment assignment. We assume those that have tau<0 should
not have treatment. Conditional Average Treatment Effect is one possible measure.}

\item{Y}{The outcome variable of interest.}
}
\value{
A list that contains the following items: \item{aupec}{The estimated
Area Under Prescription Evaluation Curve} \item{sd}{The estimated standard deviation
of AUPEC.}
}
\description{
This function estimates AUPEC. The details of the methods for this design are given in Imai and Li (2019).
}
\references{
Imai and Li (2019). \dQuote{Experimental Evaluation of Individualized Treatment Rules},
}
\author{
Michael Lingzhi Li, Operations Research Center, Massachusetts Institute of Technology
\email{mlli@mit.edu}, \url{http://mlli.mit.edu};
}
\keyword{evaluation}
